% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net_st.R
\name{net_st_pre}
\alias{net_st_pre}
\title{Preparation for context-dependent functional network construction of ST data}
\usage{
net_st_pre(x, coords, genelist, roiID, r)
}
\arguments{
\item{x}{A data frame containing spatial gene expression data (library size normalization and log2 transformation). For a data frame, each row represents a spatial location, and each column represents a gene.}

\item{coords}{A data frame with two columns (the column names are "x" and "y", corresponding to the two-dimensional coordinates of spatial locations).}

\item{genelist}{A data frame containing one column (the column name is "gene"). It records the functional gene list that reflects a specific gene program.}

\item{roiID}{A character vector containing the names of spatial locations in the region of interest (ROI).}

\item{r}{The distance used to identify the neighborhood of the user-specified ROI.}
}
\value{
Processed data. A list containing two elements ("dat" and "neighborID"). The "dat" element contains a data frame with paired data comprising actual- and pseudo-spots. The "neighborID" element contains a character vector with the names of spatial locations in the corresponding neighborhood of the ROI.
}
\description{
\code{net_st_pre} constructs the functional network and pinpoints hub genes that reflect a specific gene program in a distinct spatial context.
}
