% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net_st.R
\name{net_st}
\alias{net_st}
\title{Context-dependent functional network construction of ST data}
\usage{
net_st(x_st, genelist, select = 0.2, cluster = NULL, seed = NULL)
}
\arguments{
\item{x_st}{A data frame containing paired gene expression data after \link{net_st_pre} data preprocessing.}

\item{genelist}{A data frame containing one column (the column name is "gene"). It records the functional gene list that reflects a specific gene program.}

\item{select}{A numerical value between 0 and 1 that specifies the top percentage of important spatial locations involved in network construction.}

\item{cluster}{The number of cores to use for parallel processing. If set to 1, no parallel processing is used.}

\item{seed}{Set a random seed. Setting NULL will not set a seed.}
}
\value{
A list with two elements ("Edge" and "Node"). The "Edge" element containing edge attributes represents transcriptional co-regulation of functional genes. The "Node" element containing node attributes represents the weight of functional genes.
}
\description{
\code{net_st} constructs the functional network and pinpoints hub genes that reflect a specific gene program in a distinct spatial context.
}
