% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ident_st.R
\name{ident_st_score}
\alias{ident_st_score}
\title{Cell identity characterization (DeCEP score) of ST data}
\usage{
ident_st_score(x_impute, involvedID, net)
}
\arguments{
\item{x_impute}{A data frame containing spatial gene expression data (after imputation) in a distinct spatial context. For a data frame, each row represents a spatial location, and each column represents a gene.}

\item{involvedID}{A character vector containing the names of spatial locations in the region of interest (ROI) and corresponding neighborhood.}

\item{net}{A context-dependent functional network obtained by \link{net_st}.}
}
\value{
A data frame with two columns (the column names are "spot_ID" and "DeCEP_score").
}
\description{
\code{ident_st_score} quantifies the activity of context-specific gene program depend on \link{net_st} for individual spatial locations.
}
