% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ident_sc.R
\name{ident_sc_score}
\alias{ident_sc_score}
\title{Cell identity characterization (DeCEP score) of scRNA-seq data}
\usage{
ident_sc_score(x, net, seed = 1)
}
\arguments{
\item{x}{A data frame or a Seurat object containing single-cell gene expression data (library size normalization and log2 transformation) in a distinct cellular context. For a data frame, each row represents a cell, and each column represents a gene.}

\item{net}{A context-dependent functional network obtained by \link{net_sc}.}

\item{seed}{Set a random seed. Setting NULL will not set a seed.}
}
\value{
A data frame with two columns (the column names are "cell_ID" and "DeCEP_score").
}
\description{
\code{ident_sc_score} quantifies the activity of context-specific gene program depend on \link{net_sc} for individual cells.
}
