library(dplyr)
library(tidyverse)

sv_files<-list.files("/home/users/ayh/Projects/27_A3B/03_sequencing/single_clone_sequencing/WGS/26_delly_clonal/original",
                     "scFr.clonal.vcf",
                     full.names=T)

metadata<-read_tsv("/home/users/ayh/Projects/27_A3B/03_sequencing/single_clone_sequencing/WGS/26_delly_clonal/original/metadata.txt")

sv_tmp<-lapply(sv_files,function(x){
  read_tsv(x)%>%mutate(id=gsub(".delly.*","",basename(x)))
})

sv_df<-do.call(rbind,sv_tmp)
sv_df%>%
  write.table("/home/users/ayh/Projects/27_A3B/03_sequencing/single_clone_sequencing/WGS/26_delly_clonal/original/sv_clonal.tsv",
              quote=F,
              row.names=F,
              sep="\t")
sv_df$svtype%>%unique()

sv_review_df<-read_tsv("/home/users/ayh/Projects/27_A3B/03_sequencing/single_clone_sequencing/WGS/26_delly_clonal/original/sv_manual_review.txt")
sv_review_df<-sv_review_df%>%filter(TF=="O")%>%
  mutate(info=paste(`#CHR1`,POS1,sep="_"))

sv_files<-list.files("/home/users/ayh/Projects/27_A3B/03_sequencing/single_clone_sequencing/WGS/26_delly_clonal/original",
                     "scFr.*clonal.vcf",
                     full.names=T)

metadata<-read_tsv("/home/users/ayh/Projects/27_A3B/03_sequencing/single_clone_sequencing/WGS/26_delly_clonal/original/metadata.txt")

sv_tmp<-lapply(sv_files,function(x){
  read_tsv(x)%>%mutate(id=gsub(".delly.*","",basename(x)))%>%mutate(clonality=ifelse(grepl("subclonal",basename(x)),"subclonal","clonal"))%>%
    select(`#CHR1`,"POS1","CHR2","POS2","id","clonality")
})

sv_df<-do.call(rbind,sv_tmp)

sv_df<-sv_df%>%mutate(info=paste(`#CHR1`,POS1,sep="_"))
common_sv_info_df<-sv_df%>%
  group_by(info)%>%dplyr::summarise(n=n())%>%filter(n!=1)%>%
  arrange(-n)
write.table(common_sv_info_df,"/home/users/ayh/Projects/27_A3B/03_sequencing/single_clone_sequencing/WGS/26_delly_clonal/original/common_sv_info.240828.tsv",
            sep="\t",
            quote=F,
            row.names=F)

common_sv_df<-read_tsv("/home/users/ayh/Projects/27_A3B/03_sequencing/single_clone_sequencing/WGS/26_delly_clonal/original/common_sv_info.240828.tsv")
sv_review_df%>%filter(info%in%common_sv_df$info)%>%
  select(id,info,etc,TF)%>%print(n=100)

sv_review_filter_df<-sv_review_df%>%
  filter(!info%in%common_sv_df$info)
sv_ref_df<-data.frame(id=rep(sv_df$id%>%unique(),each=4),svtype=rep(c("DEL","INV","DUP","TRA"),33))%>%as.tibble()



sv_count_df<-left_join(sv_ref_df,sv_review_df%>%
                         group_by(id,svtype)%>%
                         dplyr::summarise(type_count=n())
)
sv_count_filter_df<-left_join(sv_ref_df,sv_review_filter_df%>%
                                group_by(id,svtype)%>%
                                dplyr::summarise(type_count=n())
)
sv_count_df[is.na(sv_count_df)]<-0
sv_count_df<-left_join(sv_count_df,sv_count_df%>%group_by(id)%>%
                         dplyr::summarise(tot_sv_count=sum(type_count)))

sv_count_filter_df[is.na(sv_count_filter_df)]<-0
sv_count_filter_df<-left_join(sv_count_filter_df,sv_count_filter_df%>%group_by(id)%>%
                                dplyr::summarise(tot_sv_count=sum(type_count)))

sv_count_filter_df%>%
  spread(svtype,type_count)%>%
  mutate(id=gsub("A3A_1st_C3_neg","A3A_1st_C3_Ctrl",id))%>%
  mutate(id=gsub("A3A_C3_100","A3A_1st_C3_100ng",id))%>%
  mutate(id=gsub("A3A_C3_3","A3A_1st_C3_3ug",id))%>%
  arrange(id)%>%
write.table("/home/users/ayh/Projects/27_A3B/06_Figure_code/edit_figure/Fig2/sv_table.txt",
            sep="\t",
            quote=F,
            row.names=F)
  print(n=100)
sv_count_filter_df
