library(dplyr)
library(tidyverse)
library(ggplot2)
sv_files<-list.files("/home/users/ayh/Projects/27_A3B/03_sequencing/single_clone_sequencing/WGS/26_delly_clonal/original",
                     "scFr.*clonal.vcf",
                     full.names=T)

metadata<-read_tsv("/home/users/ayh/Projects/27_A3B/03_sequencing/single_clone_sequencing/WGS/26_delly_clonal/original/metadata.txt")

sv_tmp<-lapply(sv_files,function(x){
  read_tsv(x)%>%mutate(id=gsub(".delly.*","",basename(x)))%>%mutate(clonality=ifelse(grepl("subclonal",basename(x)),"subclonal","clonal"))%>%
    select(`#CHR1`,"POS1","CHR2","POS2","id","clonality")
})

sv_df<-do.call(rbind,sv_tmp)

sv_df<-sv_df%>%mutate(info=paste(`#CHR1`,POS1,sep="_"))
common_sv_info_df<-sv_df%>%
  group_by(info)%>%dplyr::summarise(n=n())%>%filter(n!=1)%>%
  arrange(-n)
write.table(common_sv_info_df,"/home/users/ayh/Projects/27_A3B/03_sequencing/single_clone_sequencing/WGS/26_delly_clonal/original/common_sv_info.tsv",
            sep="\t",
            quote=F,
            row.names=F)
