library(dplyr)
library(tidyverse)

snv_files<-list.files("/home/users/ayh/Projects/27_A3B/03_sequencing/single_clone_sequencing/WGS/24_mutect2_strelka2_baseq/merge/clonal/new_filter",
                      ".prob.clonal.vcf.cont$",
                      #quote=F,
                      full.names=T)

snv_tmp<-lapply(snv_files,function(x){
  read_tsv(x)%>%mutate(id=gsub(".mutect2.*","",basename(x)))%>%
    select(`#CHROM`,POS,ID,REF,ALT,QUAL,FILTER,INFO,FORMAT,id,sig_cont)
}
)
snv_df<-do.call(rbind,snv_tmp)
snv_df<-snv_df%>%mutate(info=paste(`#CHROM`,POS,sep="_"))

common_df<-snv_df%>%
  group_by(`#CHROM`,POS,REF,ALT,sig_cont)%>%
  dplyr::summarise(n=n())%>%
  filter(n>1)%>%
  unique()%>%
  mutate(info=paste(`#CHROM`,POS,sep="_"))


excl_df<-snv_df%>%filter(!REF%in%c("A","C","G","T"))

common_df<-rbind(common_df%>%ungroup(),excl_df%>%
                   select(`#CHROM`,POS,REF,ALT,sig_cont,info)%>%
                   mutate(n=1)
)

common_df%>%
  write.table("/home/users/ayh/Projects/27_A3B/03_sequencing/single_clone_sequencing/WGS/24_mutect2_strelka2_baseq/merge/clonal/new_filter/common_snv_multi_var.vcf",
              quote=F,
              sep="\t",
              row.names=F)


