suppressMessages(library(optparse))
#args = commandArgs(trailingOnly=TRUE)

option_list <- list(
  make_option(c("-I", "--input_file"), 
              help="Input annotated vcf(#CHROM,POS,REF,ALT,gene_dir required)"),
  make_option(c("-O", "--output_dir"),  default=".",
              help="output directory"),
  make_option(c("-g", "--genome"), default="GRCh37",
              help="version of genome")
)


parser <- OptionParser(usage="%prog [options] file", option_list=option_list)


args <- parse_args(parser, positional_arguments = 0)
opt <- args$options
file <- args$args
print(opt$input_file)
print(opt$stranded_library)
if(is.null(opt$input_file)){
  print("check input file directory")
  q()
}

print("load packages")
suppressMessages(library(dplyr))
suppressMessages(library(tidyverse))
suppressMessages(library(stringi))
suppressMessages(library(BSgenome))
suppressMessages(library(Rsamtools))
suppressMessages(library(stringr))


###load files##-------------------------------------------------------------------------------------------------
if(opt$genome=="GRCh37"){
  fasta_file<-FaFile(file='/home/users/ayh/Projects/reference/genome/human/GRCh37/A3B/human_g1k_v37.rtTA.A3B_mcherry_vec.fa')
} else if(opt$genome=="mm10"){
  fasta_file<-FaFile(file='/home/users/ayh/Projects/27_A3B/03_sequencing/single_clone_sequencing/WGS/19_mouse_test/reference/human_g1k_v37.rtTA.A3B_mcherry.GRCm38.fa')
}


df<-read_tsv(opt$input_file,col_types =cols(`#CHROM`="c"))
df
#colnames(df)[1]<-"CHROM"
#-----------------------------------------------------------------------------------------------------------------

###making df-----------------------------------------------------------------------------------------------------
three_bp_df<-GRanges(seqnames=df$`#CHROM`,IRanges(start=(as.numeric(df$POS)-1), end=(as.numeric(df$POS)+1)),strand="+")
refbase<-getSeq(fasta_file,three_bp_df)
refbase<-as.data.frame(refbase)$x
df<-df%>%mutate(three_bp_cont=refbase)
out_df<-df%>%mutate(sig_cont=ifelse(REF %in%c("C","T"),
                                        paste0(substr(df$three_bp_cont,1,2),">", df$ALT,substr(df$three_bp_cont,3,3)),
                                        paste0(substr(stri_reverse(chartr("ATGC","TACG",df$three_bp_cont)),1,2),">", chartr("ATGC","TACG",df$ALT),substr(stri_reverse(chartr("ATGC","TACG",df$three_bp_cont)),3,3))
))

#out_df%>%select(REF,ALT,three_bp_cont,sig_cont)

write.table(out_df,paste0(opt$input_file,".cont"),
            row.names=F,
            quot=F,
            sep="\t")
