suppressMessages(library(optparse))

option_list <- list(
  make_option(c("-I", "--input_file"),
              help="Input annotated vcf(#CHROM,POS,REF,ALT,gene_dir required)"),
  make_option(c("-O", "--output_dir"),  default=".",
              help="output directory"),
  make_option(c("-s", "--stranded_library"), action="store_true",default=FALSE,
              help="data from stranded library, (inlude -s for stranded library)")
)
parser <- OptionParser(usage="%prog [options] file", option_list=option_list)


args <- parse_args(parser, positional_arguments = 0)
opt <- args$options
file <- args$args
print(opt$input_file)

if(is.null(opt$input_file)){
  print("check input file directory")
  q()
}

print("load packages")
suppressMessages(library(dplyr))
suppressMessages(library(tidyverse))

df<-read_tsv(opt$input_file)%>%
  mutate(info=paste(`#CHROM`,POS,sep="_"))

common_snv_df<-read_tsv("/home/users/ayh/Projects/27_A3B/03_sequencing/single_clone_sequencing/WGS/24_mutect2_strelka2_baseq/merge/indel/clonal/common_clonal_indel.vcf")

df<-df%>%filter(!info%in%common_snv_df$info)
df%>%
write.table(paste0(gsub(".clonal.vcf",".clonal.excl_common.vcf",opt$input_file)),
            sep="\t",
            quote=F,
            row.names=F)
