##from v5, edit just mv dir##

configfile: 'sample_config.yaml'
configfile: srcdir('path_config.yaml')

PYTHON = config['PYTHON2']
BEDTOOLS = config['BEDTOOLS']
GENOME= config['GENOME']
EXCLUDE_BED= config['EXCLUDE_BED']
P_DEPTH= config['P_DEPTH']
R_DEPTH= config['R_DEPTH']
R_SS_DEPTH= config['R_SS_DEPTH']
RSCRIPT= config['RSCRIPT']
FIN_DEPTH= config['FIN_DEPTH']
FIN_SS_DEPTH= config['FIN_SS_DEPTH']

wildcard_constraints:
    chrom="\d+"        


rule all:
    input:
#        expand("{sample}/{sample}.fin.covered_region.v6.txt", sample=config['sample']);
        expand("{sample}/{sample}.fin.Only_SS_lib.covered_region.v7.txt", sample=config['sample'])

        
rule python_depth:
    params:
        name = lambda x: config['sample'][x.sample]['name'],
        bam = lambda x: config['sample'][x.sample]['s_bam'],
    input:
        bam = lambda x: config['sample'][x.sample]['s_bam'],
    output:
        txt = "{sample}.s.indel.bam.depth.v9.txt"
    threads: 8
    log:
        "logs/{sample}.python_depth.log"
    shell:
#        "cat {sample}.s.indel.bam;"
        "{PYTHON} {P_DEPTH} {input.bam} > {log};"
#	"mv {sample}.s.indel.bam.depth.v9.txt {sample};"
        "touch {output.txt} > {log}"
#        "{BEDTOOLS} subtract -a {input.vcf} -b {EXCLUDE_BED} >tmp_vcf/{params.name}.snp.exclude.vcf ;"
#        "cat {HEADER} tmp_vcf/{params.name}.snp.exclude.vcf > {output.vcf}"
#print (config['sample'])

rule mv:
    params:
        name = lambda x: config['sample'][x.sample]['name'],
    input:
        txt = "{sample}.s.indel.bam.depth.v9.txt"
    output:
        txt = "{sample}/{sample}.s.indel.bam.depth.v9.txt"
    log:
        "logs/{sample}.mv.log"
    shell:
        "mkdir -p {params.name};"
        "mv {input.txt} {output.txt} > {log}"
        


rule r_depth:
    params:
        name = lambda x: config['sample'][x.sample]['name'],
        bam = lambda x: config['sample'][x.sample]['s_bam'],
    input:
        txt = "{sample}/{sample}.s.indel.bam.depth.v9.txt",
    output:
        txt = "{sample}/{sample}.s.indel.bam.processed.F1R2.F2R1.region.v6.bed",
        ss_txt="{sample}/{sample}.s.indel.bam.processed.F1R2.F2R1.Only_SS_lib.region.v6.bed",
    log:
        "logs/{sample}.r_depth.log"
    shell:
        "{RSCRIPT} {R_DEPTH} {input.txt}>{log};"
        "{RSCRIPT} {R_SS_DEPTH} {input.txt} > {log};"
        "touch {output.txt};"
        "touch {output.ss_txt}"


rule genomecov:
    params:
        name = lambda x: config['sample'][x.sample]['name'],
        bam = lambda x: config['sample'][x.sample]['s_bam'],
    input:
        bed = "{sample}/{sample}.s.indel.bam.processed.F1R2.F2R1.region.v6.bed",
        ss_bed="{sample}/{sample}.s.indel.bam.processed.F1R2.F2R1.Only_SS_lib.region.v6.bed",
    output:
        txt = "{sample}/{sample}.s.indel.bam.processed.F1R2.F2R1.region.v6.bed.covered_region.txt",
        ss_txt = "{sample}/{sample}.s.indel.bam.processed.F1R2.F2R1.Only_SS_lib.region.v6.bed.covered_region.txt"
    log:
        "logs/{sample}.genomecov.log"
    shell:
        "{BEDTOOLS} genomecov -i {input.bed} -g {GENOME} -bg 1> {output.txt} 2>{log};"
        "{BEDTOOLS} genomecov -i {input.ss_bed} -g {GENOME} -bg 1> {output.ss_txt} 2>{log};"

rule exclude:
    params:
        name = lambda x: config['sample'][x.sample]['name'],
        bam = lambda x: config['sample'][x.sample]['s_bam'],
    input:
        txt = "{sample}/{sample}.s.indel.bam.processed.F1R2.F2R1.region.v6.bed.covered_region.txt",
        ss_txt = "{sample}/{sample}.s.indel.bam.processed.F1R2.F2R1.Only_SS_lib.region.v6.bed.covered_region.txt"
        
    output:
        txt = "{sample}/{sample}.s.indel.bam.processed.F1R2.F2R1.region.v6.bed.excl.covered_region.txt",
        ss_txt = "{sample}/{sample}.s.indel.bam.processed.F1R2.F2R1.Only_SS_lib.region.v6.bed.excl.covered_region.txt"
    log:
        "logs/{sample}.exclude.log"
    shell:
        "{BEDTOOLS} subtract -a {input.txt} -b {EXCLUDE_BED} 1> {output.txt} 2> {log};"
        "{BEDTOOLS} subtract -a {input.ss_txt} -b {EXCLUDE_BED} 1> {output.ss_txt} 2> {log}"

rule sum:
    params:
        name = lambda x: config['sample'][x.sample]['name'],
        bam = lambda x: config['sample'][x.sample]['s_bam'],
    input:
        txt = "{sample}/{sample}.s.indel.bam.processed.F1R2.F2R1.region.v6.bed.excl.covered_region.txt",
        ss_txt = "{sample}/{sample}.s.indel.bam.processed.F1R2.F2R1.Only_SS_lib.region.v6.bed.excl.covered_region.txt"
    output:
        txt = "{sample}/{sample}.fin.covered_region.v7.txt",
        ss_txt = "{sample}/{sample}.fin.Only_SS_lib.covered_region.v7.txt"
    log:
        "logs/{sample}.FIN_DEPTH.log"
    shell:
        "{PYTHON} {FIN_DEPTH} {input.txt} F > {log};"
        "{PYTHON} {FIN_SS_DEPTH} {input.ss_txt} F > {log};"
        "touch {output.txt};"
        "touch {output.ss_txt}"
