suppressMessages(library(optparse))
#args = commandArgs(trailingOnly=TRUE)

option_list <- list(
  make_option(c("-I", "--input_file"),
              help="Input annotated vcf(#CHROM,POS,REF,ALT,gene_dir required)"),
  make_option(c("-O", "--output_dir"),  default=".",
              help="output directory")
  
)
parser <- OptionParser(usage="%prog [options] file", option_list=option_list)


args <- parse_args(parser, positional_arguments = 0)
opt <- args$options
file <- args$args
print(opt$input_file)
print(opt$stranded_library)
if(is.null(opt$input_file)){
  print("check input file directory")
  q()
}

print("load packages")
suppressMessages(library(dplyr))
suppressMessages(library(tidyverse))
suppressMessages(library(stringi))
suppressMessages(library(BSgenome))
suppressMessages(library(Rsamtools))
suppressMessages(library(stringr))


###load files##-------------------------------------------------------------------------------------------------
fasta_file<-FaFile(file='/home/users/ayh/Projects/reference/genome/human/GRCh37/A3B/human_g1k_v37.rtTA.A3B_mcherry_vec.fa')
df<-read_tsv(opt$input_file,col_types =cols(`#CHROM`="c"))

colnames(df)[1]<-"CHROM"
#-----------------------------------------------------------------------------------------------------------------

###making df-----------------------------------------------------------------------------------------------------
filtered_df<-df%>%filter(gene_dir!=".")


filtered_df<-filtered_df%>%mutate(align_dir=ifelse((F1R2_TF=="O"&F2R1_TF=="O")|(F1R2_TF=="X"&F2R1_TF=="X"),
                                                          ifelse(F1R2_var_readc>F2R1_var_readc,
                                                                 "F1R2",
                                                                 ifelse(F1R2_var_readc==F2R1_var_readc,
                                                                        ifelse(F1R2_tot_readc>F2R1_tot_readc,"F1R2","F2R1")
                                                                        ,"F2R1")),
                                                   ifelse(F1R2_TF=="O","F1R2","F2R1"))
)


three_bp_df<-GRanges(seqnames=filtered_df$CHROM,IRanges(start=(as.numeric(filtered_df$POS)-1), end=(as.numeric(filtered_df$POS)+1)),strand=filtered_df$gene_dir)
refbase<-getSeq(fasta_file,three_bp_df)
refbase<-as.data.frame(refbase)$x

sim_df<-filtered_df%>%select(CHROM,POS,REF,ALT,gene_dir,F1R2_TF,F2R1_TF,align_dir)%>%mutate(three_bp_cont=refbase)


sim_df<-sim_df%>%mutate(sig_cont=ifelse(gene_dir=="-",
                                        ifelse(align_dir=="F1R2",
                                               paste0(substr(sim_df$three_bp_cont,1,2),">", chartr("ATGC","TACG",sim_df$ALT),substr(sim_df$three_bp_cont,3,3)),
                                               paste0(substr(stri_reverse(chartr("ATGC","TACG",sim_df$three_bp_cont)),1,2),">", sim_df$ALT,substr(stri_reverse(chartr("ATGC","TACG",sim_df$three_bp_cont)),3,3))
                                        ),
                                        ifelse(align_dir=="F2R1",
                                               paste0(substr(sim_df$three_bp_cont,1,2),">", sim_df$ALT,substr(sim_df$three_bp_cont,3,3)),
                                               paste0(substr(stri_reverse(chartr("ATGC","TACG",sim_df$three_bp_cont)),1,2),">", chartr("ATGC","TACG",sim_df$ALT),substr(stri_reverse(chartr("ATGC","TACG",sim_df$three_bp_cont)),3,3))
                                        )
)
)




sim_df<-sim_df%>%select(CHROM,POS,three_bp_cont,sig_cont)
fin_df<-left_join(df,sim_df,by=c("CHROM"="CHROM","POS"="POS"))%>%mutate(mut_type=substr(sig_cont,2,4))

#fin_df

write.table(fin_df, file=paste0(opt$output_dir,"/",basename(opt$input_file),".cont",sep=""),row.names=FALSE, quote=FALSE,sep="\t")
