
library(dplyr)
library(tidyverse)
rna_fin_list<-list.files("/home/users/ayh/Projects/27_A3B/03_sequencing/single_clone_sequencing/WTS/14_RNA_editing_integrate/star/varscan/final/reheader/",
                         "*std.rh.incl_nodir.readinfo_filtered.vcf.vaf_med.cont.vaf_med_filtered.vcf",
                         full.names=T)
rna_fin_list
#metadata<-read_tsv("/home/users/ayh/Projects/27_A3B/03_sequencing/single_clone_sequencing/WTS/14_RNA_editing_integrate/varscan/filter_wo_gene_dir_filter/metadata.txt")
metadata<-read_tsv("/home/users/ayh/Projects/27_A3B/03_sequencing/single_clone_sequencing/WTS/14_RNA_editing_integrate/star/varscan/final/reheader/metadata.txt")

metadata<-metadata%>%mutate(old_id=gsub(".var.*","",basename(vcf)))
metadata<-metadata[-2]
#rna_fin_list<-rna_fin_list[!grepl("3ug",rna_fin_list)]
tmp<-lapply(rna_fin_list,function(x){
  read_tsv(x)%>%mutate(id=gsub(".varscan.*","",basename(x)))
})
merge_df<-do.call(rbind,tmp)


merge_df<-left_join(merge_df,metadata,by=c("id"="old_id"))

site_df<-merge_df%>%select(CHROM,POS,REF,ALT,gene_dir,APOBEC,sig_cont,id,F1R2_TF,F2R1_TF)%>%unique()%>%plyr::rename(c("APOBEC"="APOBEC_site"))


site_t_df<-site_df%>%group_by(CHROM,POS,REF,ALT,gene_dir,sig_cont,APOBEC_site)%>%dplyr::summarise(n=n())%>%filter(n>=2)%>%mutate(stat=1)

site_t_df<-site_t_df[-8]%>%spread(APOBEC_site,stat)
site_t_df<-site_t_df%>%mutate(sig_cont=ifelse(is.na(sig_cont),"NA",sig_cont))
site_t_df[is.na(site_t_df)]<-0
tot_site_df<-site_t_df%>%plyr::rename(c("A3A"="A3A_site","A3B"="A3B_site","CTRL"="CTRL_site"))

write.table(tot_site_df,"/home/users/ayh/Projects/27_A3B/03_sequencing/single_clone_sequencing/WTS/14_RNA_editing_integrate/star/varscan/final/reheader/RNA_editing_common_site.tsv",
            sep="\t",
            row.names=F,
            quote = F)
