suppressMessages(library(optparse))
#args = commandArgs(trailingOnly=TRUE)

option_list <- list(
  make_option(c("-I", "--input_file"),
              help="Input annotated vcf(#CHROM,POS,REF,ALT,gene_dir required)"),
  make_option(c("-O", "--output_dir"),  default=".",
              help="output directory")
  
)
parser <- OptionParser(usage="%prog [options] file", option_list=option_list)


args <- parse_args(parser, positional_arguments = 0)
opt <- args$options
file <- args$args
print(opt$input_file)
print(opt$stranded_library)
if(is.null(opt$input_file)){
  print("check input file directory")
  q()
}

print("load packages")
suppressMessages(library(dplyr))
suppressMessages(library(tidyverse))
suppressMessages(library(stringi))
suppressMessages(library(BSgenome))
suppressMessages(library(Rsamtools))
suppressMessages(library(stringr))


###load files##-------------------------------------------------------------------------------------------------
#fasta_file<-FaFile(file='/home/users/ayh/Projects/reference/genome/human/GRCh37/A3B/human_g1k_v37.rtTA.A3B_mcherry_vec.fa')
#df<-read_tsv(opt$input_file,col_types =cols(`#CHROM`="c"))
df<-read_tsv(opt$input_file)

#df<-read_tsv("/home/users/ayh/Projects/27_A3B/03_sequencing/single_clone_sequencing/WTS/14_RNA_editing_integrate/star/varscan/final/reheader/signature/0.001ng-1.varscan.novec.snp.vcf.anv.gd.readc.readc.readinfo.db.multi_base.std.rh.incl_nodir.readinfo_filtered.vcf.cont")

##
#df<-df%>%mutate(F1R2_TF="O",F2R1_TF="X")
##
colnames(df)[1]<-"CHROM"
#-----------------------------------------------------------------------------------------------------------------

###making df-----------------------------------------------------------------------------------------------------
#colnames(df)
#df$`F2R1_var_LocaRightMin;Med;Max`




sig_df<-df%>%mutate(align_dir=ifelse((F1R2_TF=="O"&F2R1_TF=="O")|(F1R2_TF=="X"&F2R1_TF=="X"),
                                     ifelse(F1R2_var_readc>F2R1_var_readc,
                                            "F1R2",
                                            ifelse(F1R2_var_readc==F2R1_var_readc,
                                                   ifelse(F1R2_tot_readc>F2R1_tot_readc,"F1R2","F2R1")
                                                   ,"F2R1")),
                                     ifelse(F1R2_TF=="O","F1R2","F2R1"))
)%>%mutate(var_readc=ifelse(align_dir=="F1R2",F1R2_var_readc,F2R1_var_readc))%>%
  mutate(depth=ifelse(align_dir=="F1R2",F1R2_tot_readc,F2R1_tot_readc))%>%
  mutate(vaf=var_readc/depth)%>%
  separate("F1R2_var_LocaLeftMin;Med;Max",c("F1R2_var_LocaLeftMin","F1R2_var_LocaLeftMed","F1R2_var_LocaLeftMax" ))%>%
  separate("F1R2_var_LocaRightMin;Med;Max" ,c("F1R2_var_LocalRightMin","F1R2_var_LocaRightMed","F1R2_var_LocaRightMax"))%>%
  separate("F2R1_var_LocaLeftMin;Med;Max",c("F2R1_var_LocaLeftMin","F2R1_var_LocaLeftMed","F2R1_var_LocaLeftMax" ))%>%
  separate("F2R1_var_LocaRightMin;Med;Max" ,c("F2R1_var_LocalRightMin","F2R1_var_LocaRightMed","F2R1_var_LocaRightMax"))%>%
  rename(c("F1R2_var_LocaRightSTD"="F2R1_var_LocaLeftSTD","F2R1_var_LocaLeftSTD"="F1R2_var_LocaRightSTD"))
#colnames(sig_df)
#sig_df$F2R1_var_locaRightMed
sig_df<-sig_df%>%mutate(Med_L=ifelse(align_dir=="F1R2",F1R2_var_LocaLeftMed,F2R1_var_LocaLeftMed))%>%
	mutate(Med_R=ifelse(align_dir=="F1R2",F1R2_var_LocaRightMed,F2R1_var_LocaRightMed))%>%
  mutate(std_L=ifelse(align_dir=="F1R2",F1R2_var_LocaLeftSTD,F2R1_var_LocaLeftSTD))%>%
  mutate(std_R=ifelse(align_dir=="F1R2",F1R2_var_LocaRightSTD,F2R1_var_LocaRightSTD))

write.table(sig_df, file=paste0(opt$output_dir,"/",basename(opt$input_file),".vaf_med",sep=""),row.names=FALSE, quote=FALSE,sep="\t")
