suppressMessages(library(optparse))

option_list <- list(
  make_option(c("-I", "--input_file"),
              help="Input annotated vcf(#CHROM,POS,REF,ALT,gene_dir required)"),
  make_option(c("-F", "--filtered_file"),
              help="Input annotated filtered vcf(#CHROM,POS,REF,ALT,gene_dir required)"),
  make_option(c("-O", "--output_dir"),  default=".",
              help="output directory"),
  make_option(c("-s", "--stranded_library"), action="store_true",default=FALSE,
              help="data from stranded library, (inlude -s for stranded library)")
)
parser <- OptionParser(usage="%prog [options] file", option_list=option_list)


args <- parse_args(parser, positional_arguments = 0)
opt <- args$options
file <- args$args
print(opt$input_file)

if(is.null(opt$input_file)){
  print("check input file directory")
  q()
}

print("load packages")
suppressMessages(library(dplyr))
suppressMessages(library(tidyverse))


df<-read_tsv(opt$input_file)
filter_df<-read_tsv(opt$filtered_file)
#df<-read_tsv("/home/users/ayh/Projects/27_A3B/03_sequencing/single_clone_sequencing/WTS/14_RNA_editing_integrate/star/varscan/final/reheader/A3B_1st_C5_3ng_48h_1.varscan.novec.snp.vcf.anv.gd.readc.readc.readinfo.db.multi_base.std.rh.tot.incl_nodir.readinfo_filtered.vcf.vaf_med.cont")

#filter_df<-read_tsv("/home/users/ayh/Projects/27_A3B/03_sequencing/single_clone_sequencing/WTS/14_RNA_editing_integrate/star/varscan/final/reheader/A3B_1st_C5_3ng_48h_1.varscan.novec.snp.vcf.anv.gd.readc.readc.readinfo.db.multi_base.std.rh.incl_nodir.readinfo_filtered.vcf.vaf_med.cont.vaf_med_filtered.vcf")

df<-df%>%mutate(info=paste(CHROM,POS,REF,ALT,align_dir,sig_cont))

filter_df<-filter_df%>%mutate(info=paste(CHROM,POS,REF,ALT,align_dir,sig_cont))

reform_df<-df%>%mutate(TF_stat=ifelse(df$info %in% filter_df$info, 1,0))%>%
  mutate(F1R2_TF=ifelse(TF_stat==0,"X",F1R2_TF),F2R1_TF=ifelse(TF_stat==0,"X",F2R1_TF))


std_df<-read_tsv("/home/users/ayh/Projects/27_A3B/03_sequencing/single_clone_sequencing/WTS/14_RNA_editing_integrate/star/varscan/final/reheader/RNA_editing_common_site.tsv")


res_df<-left_join(reform_df,std_df,by=c("CHROM"="CHROM","POS"="POS","REF"="REF","ALT"="ALT","gene_dir"="gene_dir","sig_cont"="sig_cont"))

#colnames(res_df)
#res_df$A3A_site%>
res_df$A3A_site[is.na(res_df$A3A_site)]<-0
res_df$A3B_site[is.na(res_df$A3B_site)]<-0
res_df$CTRL_site[is.na(res_df$CTRL_site)]<-0

res_df<-res_df%>%mutate(rescue=ifelse(F1R2_TF=="O"|F2R1_TF=="O","X",
                                      ifelse(F1R2_TF=="X"&F2R1_TF=="X"&(A3A_site==1|A3B_site==1|CTRL_site==1),"O","X")))

res_filter_df<-res_df%>%filter(F1R2_TF=="O"|F2R1_TF=="O"|A3A_site==1|A3B_site==1|CTRL_site==1)

write.table(res_filter_df, file=paste0(opt$output_dir,"/",gsub(".tot","",basename(opt$input_file)),".vaf_med_filtered.rescue.vcf"),
            row.names=FALSE,
            quote=FALSE,
            sep="\t")
