library(dplyr)
library(tidyverse)
library(plyr)
rna_fin_list<-list.files("/home/users/ayh/Projects/27_A3B/03_sequencing/single_clone_sequencing/WTS/14_RNA_editing_integrate/star/varscan/final/reheader",
                         "*.db.multi_base.std.rh.incl_nodir.readinfo_filtered.vcf.vaf_med.cont.vaf_med_filtered.rescue.vcf.pre",
                         full.names=T)
rna_fin_list
metadata<-read_tsv("/home/users/ayh/Projects/27_A3B/03_sequencing/single_clone_sequencing/WTS/14_RNA_editing_integrate/star/varscan/final/reheader/metadata.txt")
tmp<-lapply(rna_fin_list,function(x){
  read_tsv(x)
})

merge_df<-do.call(rbind,tmp)
metadata<-metadata%>%mutate(old_id=gsub(".varscan.*","",basename(vcf)))%>%select(id,APOBEC,time,dose,batch,rep,old_id)%>%plyr::rename(c("id"="new_id"))
sim_df<-merge_df
fin_df<-left_join(sim_df,metadata,by=c("id"="old_id"))
fin_df$normal_ref_readN<-as.double(fin_df$normal_ref_readN)
fin_df$normal_var_readN<-as.double(fin_df$normal_var_readN)
fin_df$tumor_ref_readN<-as.double(fin_df$tumor_ref_readN)
fin_df$tumor_var_readN<-as.double(fin_df$tumor_var_readN)
fin_df<-fin_df%>%mutate(tumor_DNA_readN=tumor_ref_readN+tumor_var_readN,normal_DNA_readN=normal_ref_readN+normal_var_readN)%>%select(-tumor_var_readN,-tumor_vaf,-normal_var_readN,-normal_vaf)
fin_df<-fin_df%>%select(-tumor_ref_readN,-normal_ref_readN)
fin_df<-fin_df%>%mutate(rescue=ifelse(rescue=="X",0,1))
write.table(fin_df%>%filter(CHROM!="Y"),"/home/users/ayh/Projects/27_A3B/03_sequencing/single_clone_sequencing/WTS/14_RNA_editing_integrate/star/varscan/final/reheader/APOBEC_rna_editing.v8.tsv",
            row.names=F,
            quote=F,
            sep="\t")
