suppressMessages(library(optparse))
option_list <- list(
  make_option(c("-I", "--input_file"),
              help="Input annotated vcf(#CHROM,POS,REF,ALT,gene_dir required)"),
  make_option(c("-O", "--output_dir"),  default=".",
              help="output directory")

)
parser <- OptionParser(usage="%prog [options] file", option_list=option_list)


args <- parse_args(parser, positional_arguments = 0)
opt <- args$options
file <- args$args
print(opt$input_file)
print(opt$stranded_library)
if(is.null(opt$input_file)){
  print("check input file directory")
  q()
}

print("load packages")
suppressMessages(library(dplyr))
suppressMessages(library(tidyverse))
suppressMessages(library(plyr))

###load files##-------------------------------------------------------------------------------------------------
#fasta_file<-FaFile(file='/home/users/ayh/Projects/reference/genome/human/GRCh37/A3B/human_g1k_v37.rtTA.A3B_mcherry_vec.fa')
df<-read_tsv(opt$input_file,col_types =cols(`#CHROM`="c"))%>%mutate(id=gsub(".varscan.*","",basename(opt$input_file)))

#merge_df%>%select(var_readc)%>%

sim_df<-df%>%select(id,CHROM,POS,REF,ALT,gene_dir,var_readc,depth,align_dir,F1R2_var_readc,F2R1_var_readc,F1R2_tot_readc,F2R1_tot_readc,sig_cont,rescue,Med_L,Med_R,std_L,std_R,Func_refGene,Gene_refGene,ExonicFunc_refGene,"tumor_genome_ref_readN;var_readN;vaf%","normal_genome_ref_readN;var_readN;vaf%",rescue,gene_dir)%>%
  separate(`tumor_genome_ref_readN;var_readN;vaf%`,c("tumor_ref_readN","tumor_var_readN","tumor_vaf"))%>%
  separate(`normal_genome_ref_readN;var_readN;vaf%`,c("normal_ref_readN","normal_var_readN","normal_vaf"))

write.table(sim_df, file=paste0(opt$output_dir,"/",basename(opt$input_file),".pre",sep=""),row.names=FALSE, quote=FALSE,sep="\t")
#sim_df
