configfile: 'sample_config.yaml'
configfile: srcdir('path_config.yaml')

BWA = config['BWA']
SAMTOOLS = config['SAMTOOLS']
PICARD = config['PICARD']
JAVA = config['JAVA']
GATK = config['GATK']
VARSCAN = config['VARSCAN']
ANNOVAR = config['ANNOVAR']
GENE_DIR = config['GENE_DIR']
DARNED = config['DARNED']
READCOUNT= config['READCOUNT']
READINFO = config['READINFO']
FILTER = config['FILTER']
SENSE = config['SENSE']
READSTRAND = config['READSTRAND']
STRAND_FILTER= config['STRAND_FILTER']
REFERENCE= config['A3B_REFERENCE']
PYTHON = config['PYTHON2']
RSCRIPT= config['RSCRIPT']
DB= config['DB']
FITTING= config['FITTING']
READINFOFILTER= config['READINFO_FILTER']
MULTIBASE=config['MULTIBASE']
wildcard_constraints:
    sample="[a-z,A-Z,0-9,\\-,_,\\.]*"

sample=config['sample']
print( sample)
rule all:
    input:
        expand("varscan/signature/{sample}.varscan.novec.snp.vcf.anv.gd.readc.readc.readinfo.db.multi_base.incl_nodir.readinfo_filtered.vcf.cont", sample=config['sample']), 

rule varscan:
    params:
        name = lambda x: config['sample'][x.sample]['name']
    input:
        rna_bam=lambda x: config['sample'][x.sample]['r_bam']
    output:
        snp="varscan/{sample}.varscan.snp.vcf",
        suc="varscan/{sample}.varscan.suc"
    log:
        "logs/{sample}.varscan.log"
    threads: 2
    shell:
        "touch varscan/{params.name}.varscan.fail 2>{log};"
        "{SAMTOOLS} mpileup -d 100000000 -Q 20 -q 20 -B -f {REFERENCE} {input.rna_bam} |  {JAVA} -jar {VARSCAN}  mpileup2snp --min-covage 4 --min-reads2 1 --min-var-freq 0.000000001 --output-vcf 1  --p-value 0.9999999999 --purity 0.0001 1>{output.snp} 2>{log} ;"
        "mv varscan/{params.name}.varscan.fail {output.suc} 2>{log} ;"
        

rule novec:
    params:
        name = lambda x: config['sample'][x.sample]['name']
    input:
        vcf="varscan/{sample}.varscan.snp.vcf",
        prev_suc="varscan/{sample}.varscan.suc"
    output:
        vcf="varscan/{sample}.varscan.novec.snp.vcf",
        suc="varscan/{sample}.novec.suc"
    threads: 1
    log:
        "logs/{sample}.novec.log"

    shell:
        "touch varscan/{params.name}.novec.fail 2>{log} ;"
        "grep -v vec {input.vcf} | grep -v mCherry  > {output.vcf} ;"
        "mv varscan/{params.name}.novec.fail {output.suc} 2>{log} ;"

rule annovar:
    params:
        name = lambda x: config['sample'][x.sample]['name']
    input:
        vcf="varscan/{sample}.varscan.novec.snp.vcf",
        prev_suc="varscan/{sample}.novec.suc"
    output:
        vcf="varscan/{sample}.varscan.novec.snp.vcf.anv",
        suc="varscan/{sample}.annovar.suc"
    threads: 1
    log:
        "logs/{sample}.annovar.log"
    shell:
        "touch varscan/{params.name}.annovar.fail 2>{log} ;"
        "{PYTHON} {ANNOVAR} -b hg19 -i \"refGene,1000g2015aug_all,1000g2015aug_eas,exac03,cosmic86_coding\" {input.vcf}>{log};"
        "mv varscan/{params.name}.annovar.fail {output.suc} 2>{log};"

rule gene_dir:
    params:
        name = lambda x: config['sample'][x.sample]['name']
    input:
        vcf="varscan/{sample}.varscan.novec.snp.vcf.anv",
        prev_suc="varscan/{sample}.annovar.suc"
    output:
        vcf="varscan/{sample}.varscan.novec.snp.vcf.anv.gd",
        suc="varscan/{sample}.gene_dir.suc"
    threads: 1
    log:
        "logs/{sample}.gene_dir.log"
    shell:
        "touch varscan/{params.name}.gene_dir.fail 2>{log} ;"
        "{PYTHON} {GENE_DIR} {input.vcf} 11 12 13 > {log};"
        "mv varscan/{params.name}.gene_dir.fail {output.suc} 2>{log};"

rule t_info:
    params:
        name = lambda x: config['sample'][x.sample]['name']
    input:
        t_bam= lambda x: config['sample'][x.sample]['t_bam'],
        vcf="varscan/{sample}.varscan.novec.snp.vcf.anv.gd",
        prev_suc="varscan/{sample}.gene_dir.suc"
    output:
        vcf="varscan/{sample}.varscan.novec.snp.vcf.anv.gd.readc",
        suc="varscan/{sample}.t_info.suc"
    threads: 1
    log:
        "logs/{sample}.t_read_count.log"
    shell:
        "touch varscan/{params.name}.t_info.fail 2>{log} ;"
        "{PYTHON} {READCOUNT} {input.vcf} {input.t_bam} tumor_genome > {log};"
        "mv varscan/{params.name}.t_info.fail {output.suc} 2>{log};"

rule n_info:
    params:
        name = lambda x: config['sample'][x.sample]['name']
    input:
        n_bam=lambda x: config['sample'][x.sample]['n_bam'],
        vcf="varscan/{sample}.varscan.novec.snp.vcf.anv.gd.readc",
        prev_suc="varscan/{sample}.t_info.suc"

    output:
        vcf="varscan/{sample}.varscan.novec.snp.vcf.anv.gd.readc.readc",
        suc="varscan/{sample}.n_info.suc"
    threads: 1
    log:
        "logs/{sample}.n_info.log"
    shell:
        "touch varscan/{params.name}.n_info.fail 2>{log} ;"
        "{PYTHON} {READCOUNT} {input.vcf} {input.n_bam} normal_genome > {log};"
        "mv varscan/{params.name}.n_info.fail {output.suc} 2>{log};"

rule readinfo:
    params:
        name = lambda x: config['sample'][x.sample]['name']
    input:
        vcf="varscan/{sample}.varscan.novec.snp.vcf.anv.gd.readc.readc",
        r_bam=lambda x: config['sample'][x.sample]['r_bam'],
        prev_suc="varscan/{sample}.n_info.suc"
    output:
        suc="varscan/{sample}.readinfo.suc",
        vcf="varscan/{sample}.varscan.novec.snp.vcf.anv.gd.readc.readc.readinfo"
    threads: 1
    log:
        "logs/{sample}.readinfo.log"
    shell:
        "touch varscan/{params.name}.readinfo.fail 2>{log} ;"
        "{PYTHON} {READINFO} {input.vcf} {input.r_bam} > {log};"
        "mv varscan/{params.name}.readinfo.fail {output.suc} 2>{log};"
rule db:
    params:
        name = lambda x: config['sample'][x.sample]['name']
    input:
        vcf="varscan/{sample}.varscan.novec.snp.vcf.anv.gd.readc.readc.readinfo",
        prev_suc="varscan/{sample}.readinfo.suc"
    output:
        suc="varscan/{sample}.db.suc",
        vcf="varscan/{sample}.varscan.novec.snp.vcf.anv.gd.readc.readc.readinfo.db"
    threads: 1
    log:
        "logs/{sample}.readinfo.log"
    shell:
        "touch varscan/{params.name}.db.fail 2>{log} ;"
        "{RSCRIPT} {DB} -I {input.vcf} -O varscan;"
        "mv varscan/{params.name}.db.fail {output.suc} 2>{log};"

rule multibase:
    params:
        name = lambda x: config['sample'][x.sample]['name']
    input:
        vcf="varscan/{sample}.varscan.novec.snp.vcf.anv.gd.readc.readc.readinfo.db",
        r_bam=lambda x: config['sample'][x.sample]['r_bam'],
        prev_suc="varscan/{sample}.db.suc"
    output:
        suc="varscan/{sample}.multibase.suc",
        vcf="varscan/{sample}.varscan.novec.snp.vcf.anv.gd.readc.readc.readinfo.db.multi_base"
    threads: 1
    log:
        "logs/{sample}.multibase.log"
    shell:
        "touch varscan/{params.name}.multibase.fail 2>{log} ;"
        "{PYTHON} {MULTIBASE} {input.vcf} {input.r_bam};"
        "mv varscan/{params.name}.multibase.fail {output.suc} 2>{log};"


rule readinfo_filter:
    params:
        name = lambda x: config['sample'][x.sample]['name']
    input:
        vcf="varscan/{sample}.varscan.novec.snp.vcf.anv.gd.readc.readc.readinfo.db.multi_base",
        prev_suc="varscan/{sample}.multibase.suc"
    output:
        suc="varscan/{sample}.readinfo_filter.suc",
        vcf="varscan/{sample}.varscan.novec.snp.vcf.anv.gd.readc.readc.readinfo.db.multi_base.incl_nodir.readinfo_filtered.vcf"
    threads: 1
    log:
        "logs/{sample}.readinfo_filter.log"
    shell:
        "touch varscan/{params.name}.readinfo_filter.fail 2>{log};"
        "{PYTHON} {READINFOFILTER} {input.vcf};"
        "mv varscan/{params.name}.readinfo_filter.fail {output.suc}"

rule fitting:
    params:
        name = lambda x: config['sample'][x.sample]['name']
    input:
        vcf="varscan/{sample}.varscan.novec.snp.vcf.anv.gd.readc.readc.readinfo.db.multi_base.incl_nodir.readinfo_filtered.vcf",
        prev_suc="varscan/{sample}.db.suc"
    output:
        suc="varscan/{sample}.readinfo_filter.suc",
        vcf="varscan/signature/{sample}.varscan.novec.snp.vcf.anv.gd.readc.readc.readinfo.db.multi_base.incl_nodir.readinfo_filtered.vcf.cont"
    threads: 1
    log:
        "logs/{sample}.readinfo_filter.log"
    shell:
        "touch varscan/{params.name}.fitting.fail 2>{log};"
        "mkdir -p varscan/signature ;"
        "{RSCRIPT} {FITTING} -I {input.vcf} -O varscan/signature ;"
        "mv varscan/{params.name}.fitting.fail {output.suc}"

