library(dplyr)
library(tidyverse)
options(scipen=999)
A3A_files<-list.files("/home/users/ayh/Projects/27_A3B/03_sequencing/single_clone_sequencing/WTS/20_endogenous_expression/results/A3A",
                      "base.txt",
                      full.names=T)
A3A_tmp<-lapply(A3A_files,function(x){
  read_tsv(x)
})

A3A_df<-do.call(rbind,A3A_tmp)
A3A_df<-A3A_df%>%mutate(endo=`C/C`+`T/T`,exo=`T/C`)%>%
  mutate(tot=endo+exo)%>%
  mutate(endo_ratio=endo/tot)

A3B_files<-list.files("/home/users/ayh/Projects/27_A3B/03_sequencing/single_clone_sequencing/WTS/20_endogenous_expression/results/A3B",
                      "base.txt",
                      full.names=T)

A3B_tmp<-lapply(A3B_files,function(x){
  read_tsv(x)
})

A3B_df<-do.call(rbind,A3B_tmp)

A3B_df<-A3B_df%>%mutate(endo=`C`,exo=`T`)%>%
  mutate(tot=endo+exo)%>%
  mutate(endo_ratio=endo/tot)%>%print(n=100)%>%
  filter(!grepl("A3B_1st_Ctrl",id)&!grepl("Ctr_",id))
metadata<-read_tsv("/home/users/ayh/Projects/27_A3B/03_sequencing/single_clone_sequencing/WTS/20_endogenous_expression/metadata.txt")
A3A_fin_df<-left_join(A3A_df,metadata)%>%
  select(new_id,chr,pos1,pos2,spanning_total,qualified_reads,`C/C`,`T/T`,`T/C`,`C/T`,endo,exo,tot,endo_ratio)%>%
  filter(!grepl("bat2",new_id))%>%
  plyr::rename(c("new_id"="id"))

A3B_fin_df<-left_join(A3B_df,metadata)%>%
  select(new_id,chr,pos1,spanning_total,qualified_reads,`C`,`T`,endo,exo,tot,endo_ratio)%>%
  filter(!grepl("bat2",new_id))%>%
  plyr::rename(c("new_id"="id"))

A3A_fin_df%>%
  write.table("/home/users/ayh/Projects/27_A3B/03_sequencing/single_clone_sequencing/WTS/20_endogenous_expression/A3A_endo_ratio.txt",
              sep="\t",
              quote=F,
              row.names=F)
A3A_fin_df%>%
  write.table("/home/users/ayh/Projects/27_A3B/07_revision/endogenous_analysis/A3A_endo_ratio.txt",
              sep="\t",
              quote=F,
              row.names=F)

A3B_fin_df%>%
  write.table("/home/users/ayh/Projects/27_A3B/03_sequencing/single_clone_sequencing/WTS/20_endogenous_expression/A3B_endo_ratio.txt",
              sep="\t",
              quote=F,
              row.names=F)
A3B_fin_df%>%
  write.table("/home/users/ayh/Projects/27_A3B/07_revision/endogenous_analysis/A3B_endo_ratio.txt",
              sep="\t",
              quote=F,
              row.names=F)
