suppressMessages(library(optparse))
#args = commandArgs(trailingOnly=TRUE)
options(scipen=999)
option_list <- list(
  make_option(c("-I", "--input_file"),
              help="Input annotated vcf(#CHROM,POS,REF,ALT,gene_dir required)"),
  make_option(c("-A", "--annot_file"),
              help="Input annotated vcf(#CHROM,POS,REF,ALT,gene_dir required)"),
  make_option(c("-O", "--output_dir"),  default=".",
              help="output directory")
  
)
parser <- OptionParser(usage="%prog [options] file", option_list=option_list)


args <- parse_args(parser, positional_arguments = 0)
opt <- args$options
file <- args$args
print(opt$input_file)
print(opt$stranded_library)
if(is.null(opt$input_file)){
  print("check input file directory")
  q()
}

library(dplyr)
library(tidyverse)

ori_df<-read_tsv(opt$input_file)%>%
  mutate(id=basename(gsub(".vcf.cont$","",basename(opt$input_file))))%>%
  mutate(condition=gsub("^[a-z]*_sample_vcf_[0-9]*-[0-9]_","",id))%>%
  mutate(condition=gsub("_[0-9]*","",condition))%>%
  mutate(simul=gsub("_sample_vcf.*","",id))%>%
#  mutate(condition=gsub("_[0-9]*$","",gsub("sample_vcf_","",id)))%>%
  mutate(condition=as.double(condition))
annot_df<-read_tsv(opt$annot_file)

#kataegis_sample_vcf_100-1_100000_10

ori_df<-ori_df%>%mutate(info=paste(`#CHROM`,POS,sep="_"))

annot_df<-annot_df%>%plyr::rename(c("chr"="#CHROM","start"="POS","samples"="id","cluster_type_omikli_upto_3"="cluster"))%>%
  mutate(info=paste(`#CHROM`,POS,sep="_"))
annot_df%>%
  select(info,cluster,cluster_id,imd_cutoff)

merge_df<-left_join(ori_df,
          annot_df%>%
            select(info,cluster,cluster_id,imd_cutoff))
merge_df<-merge_df%>%mutate(cluster_id=ifelse(is.na(cluster_id),".",cluster_id))%>%
  mutate(cluster=ifelse(is.na(cluster),"non-clust",cluster))
#print(merge_df)
merge_df<-merge_df%>%select(`#CHROM`,POS,REF,ALT,id,condition,cluster,cluster_id,imd_cutoff,sig_cont,simul)
print(merge_df)
merge_df<-merge_df%>%mutate(imd_cutoff=(annot_df$imd_cutoff)%>%unique())
write.table(merge_df,paste0(opt$output_dir,"/",gsub(".cont$",".merge.cont",basename(opt$input_file))),
            sep="\t",
            quote=F,
            row.names=F)

