library(dplyr)
library(tidyverse)
library(ggplot2)
options(scipen=999)

list.files("/home/users/ayh/Projects/27_A3B/01_public_data/pcawg/discovery_simulation/add_simulation/unique_vaf/fin/03_merge_results/v4",
)


id_df<-read_tsv("/home/users/ayh/Projects/27_A3B/01_public_data/pcawg/discovery_simulation/add_simulation/unique_vaf/fin/id.v4.txt")

#mutate(condition=gsub("_.*","",gsub("^.*-[0-9]*_","",id)))
id_df$std<-as.numeric(id_df$std)
id_df$condition<-as.numeric(id_df$condition)
simul_merge_f_df<-read_tsv("/home/users/ayh/Projects/27_A3B/01_public_data/pcawg/discovery_simulation/add_simulation/unique_vaf/fin/03_merge_results/v4/simul_merge_f_df.tsv")%>%
  select(id,imd_cutoff,simul,std,condition)%>%unique()

sum_files_to_read<-list.files("/home/users/ayh/Projects/27_A3B/01_public_data/pcawg/discovery_simulation/add_simulation/unique_vaf/fin/03_merge_results/v4",
                              ".*simul.*txt",
                              full.names=T)
sum_files_tmp<-lapply(sum_files_to_read,function(x){
  read_tsv(x)
})
simul_merge_f_sum_df<-do.call(rbind,sum_files_tmp)
#simul_merge_f_sum_df<-read_tsv("/home/users/ayh/Projects/27_A3B/01_public_data/pcawg/discovery_simulation/add_simulation/unique_vaf/omikli/100/simul_merge_f_sum_df.omikli.txt")
simul_merge_f_sum_df<-left_join(simul_merge_f_sum_df,simul_merge_f_df)
simul_merge_f_sum_df<-left_join(id_df,simul_merge_f_sum_df)
simul_merge_f_sum_df[is.na(simul_merge_f_sum_df)]<-0

simul_merge_f_sum_df<-simul_merge_f_sum_df%>%unique()
simul_merge_f_sum_df$condition<-simul_merge_f_sum_df$condition%>%as.double()

#simul_merge_f_sum_df$std<-factor(simul_merge_f_sum_df$std,levels=c(25,50,75,100,250,500))
simul_merge_f_sum_df$std<-as.numeric(simul_merge_f_sum_df$std)
simul_merge_f_sum_df<-simul_merge_f_sum_df%>%mutate(class=simul_merge_f_sum_df$std)
simul_merge_f_sum_df$class<-factor(simul_merge_f_sum_df$class,levels=c(25,50,75,100,250,500))

#facet_wrap(~cluster)#+



simul_merge_f_sum_df<-simul_merge_f_sum_df%>%mutate(type=paste(simul,std,sep="_"))

library(drc)
library(ggpmisc)
library(aomisc)

simul_merge_f_sum_df<-simul_merge_f_sum_df%>%mutate(simul_class=paste(simul,std,sep="_"))


df<-simul_merge_f_sum_df%>%filter(simul=="kataegis")

lapply(c("kataegis","omikli"),function(x){
  #x="kataegis"
  df<-simul_merge_f_sum_df%>%filter(simul==x)
  #SSmicmen(x, Vm, K)
  #df[is.na(df$count/df$std),]
  #df[is.infinite(df$count/df$std),]
  dosefit<-nls(count/std ~ SSasymp(imd_cutoff, Asym,R0,lrc), data = df)
  coef(dosefit)
})


#summary
#kataegis
#y=1.01-1.02*exp(-exp(-7.17)*x)
#omikli
#y=0.93-0.92*exp(-exp(-6.21)*x)


simul_merge_f_sum_df<-simul_merge_f_sum_df%>%mutate(std2=as.character(std))
simul_merge_f_sum_df$std2<-factor(simul_merge_f_sum_df$std2,levels=c(25,50,75,100,250,500))

Plot_o<-simul_merge_f_sum_df%>%filter(simul=="omikli")%>%
  ggplot(aes(y=count/std,x=imd_cutoff,col=std2,))+
  geom_point()+
  facet_wrap(~simul)+
  #  stat_smooth()+
  #nls(rate~SSmicmen(conc, Vm, K)
  geom_smooth(method="nls", formula=y~SSasymp(x, Asym, R0, lrc), color="red", se=F, fullrange=T)+
  theme_bw()+
  #  ggtitle("omikli(n=100)")+
  theme(axis.text=element_text(size=30),
        axis.title=element_text(size=30))+
  ylab("found_ratio")

ggsave("/home/users/ayh/Projects/27_A3B/06_Figure_code/edit_figure/FigS/omi_simul.pdf",Plot_o,
       width=10,height=10)
Plot_k<-simul_merge_f_sum_df%>%filter(simul=="kataegis")%>%
  ggplot(aes(y=count/std,x=imd_cutoff,col=std2,))+
  geom_point()+
  facet_wrap(~simul)+
  #  stat_smooth()+
  #nls(rate~SSmicmen(conc, Vm, K)
  geom_smooth(method="nls", formula=y~SSasymp(x, Asym, R0, lrc), color="red", se=F, fullrange=T)+
  theme_bw()+
  #  ggtitle("omikli(n=100)")+
  theme(axis.text=element_text(size=30),
        axis.title=element_text(size=30))+
  ylab("found_ratio")

ggsave("/home/users/ayh/Projects/27_A3B/06_Figure_code/edit_figure/FigS/kataegis_simul.pdf",Plot_k,
         width=10,height=10)
  
