library(dplyr)
library(tidyverse)
library(ggplot2)

##RSEM output as input#
exp_files<-list.files("/home/users/ayh/Projects/27_A3B/03_sequencing/single_clone_sequencing/WTS/08_A3B_A3A",
                      "genes.results",
                      full.names=T) 

exp_files<-exp_files[(grepl("A3B_1st_C5",exp_files)|grepl("A3A_1st_C3",exp_files))&!(grepl("TP53",exp_files))&(grepl("0h",exp_files)|grepl("48h",exp_files)|grepl("Ctrl",exp_files))]


exp_files<-exp_files[!basename(exp_files)%in%c("A3A_1st_C3_48h_3ug.genes.results")]
exp_files<-exp_files[(!grepl("Ctrl",exp_files))]


exp_tmp<-lapply(exp_files,function(x){
  read_tsv(x)%>%mutate(gene_id=gsub("ENSG.*_","",gene_id))%>%
    mutate(id=gsub(".genes.*","",basename(x)))%>%
    mutate(TP53=ifelse(grepl("TP53",id),"KO","WT"))%>%
    mutate(dose=ifelse(grepl("3ug",id),"3ug",
                       ifelse(grepl("100ng_ctrl",id),"100ng",
                              ifelse(grepl("Ctrl",id)|grepl("ctrl",id)|grepl("0h",id),"CTRL","100ng"))))%>%
    select(gene_id,TPM,id,TP53,dose)
}
)

exp_df<-do.call(rbind,exp_tmp)

exp_df$dose<-factor(exp_df$dose,levels=c("CTRL","100ng","3ug"))
exp_df$TP53<-factor(exp_df$TP53,levels=c("WT","KO"))



exp_df<-exp_df%>%mutate(APOBEC=ifelse(grepl("A3A",id),"A3A","A3B"))

APOBEC_ci_df<-exp_df%>%
  filter(gene_id=="APOBEC3A"|gene_id=="APOBEC3B")%>%
  group_by(APOBEC,gene_id,TP53,dose) %>%
  summarise(mean.TPM = mean(TPM, na.rm = TRUE),
            sd.TPM = sd(TPM, na.rm = TRUE),
            n.TPM = n(),
            se=sd.TPM/sqrt(n.TPM))%>%
  mutate(dse=0.434/mean.TPM*se)

fin_exp_df<-left_join(exp_df%>%
                        filter(gene_id=="APOBEC3A"|gene_id=="APOBEC3B")%>%
                        group_by(APOBEC,gene_id,TP53,dose) %>%
                        summarise(mean.TPM = mean(TPM), na.rm = TRUE),
                      APOBEC_ci_df)%>%
  mutate(max.TPM=mean.TPM+se,
         min.TPM=mean.TPM-se)



A3A_p_df<-exp_df%>%
  filter(gene_id=="APOBEC3A"|gene_id=="APOBEC3B")%>%
  filter(APOBEC=="A3A")%>%
  filter(gene_id=="APOBEC3A")%>%
  #group_by(dose)%>%
  rstatix::t_test(TPM~dose,p.adjust.method ="BH")%>%
  rstatix::add_significance()%>%
  rstatix::add_xy_position()

A3B_p_df<-exp_df%>%
  filter(gene_id=="APOBEC3A"|gene_id=="APOBEC3B")%>%
  filter(APOBEC=="A3B")%>%
  filter(gene_id=="APOBEC3B")%>%
  #group_by(dose)%>%
  rstatix::t_test(TPM~dose,p.adjust.method ="BH")%>%
  rstatix::add_significance()%>%
  rstatix::add_xy_position()



p_a<-fin_exp_df%>%
  filter(APOBEC=="A3A")%>%
  filter(gene_id=="APOBEC3A")%>%
  ggplot(aes(x=dose,y=mean.TPM,col="black"))+
  geom_bar(stat="identity")+
  #scale_y_log10()+
  theme_classic()+
  geom_errorbar(aes(ymin=mean.TPM-se,ymax=mean.TPM+se))+
  theme(axis.title=element_text(size=40,face="bold"),
        axis.text=element_text(size=35),
        strip.text=element_text(size=35,face="italic"),
        strip.background=element_blank(),
        legend.text=element_text(size=30),
        legend.title=element_text(size=30),
        axis.ticks.y=element_line(size=2),
        axis.ticks.x=element_line(size=2),
        axis.ticks.length.y=unit(5,"mm"),
        axis.ticks.length.x=unit(3,"mm"),
        legend.position="none",
        legend.key = element_rect(color="black"),
        legend.key.size = unit(1, 'cm')
        #        panel.background=element_rect(fill=NA,color="black"),
        #        panel.border = element_rect(fill=NA,color="black")
  )+
  ylab("Expression level ( TPM )")+
  #scale_fill_manual(values = c(c3[3],c3[2]))+

  coord_cartesian(clip = "off")+
  xlab("")+
  scale_colour_manual(values=c("black","black","black"))+
  #scale_y_continuous(
  #  trans = scales::pseudo_log_trans(sigma = 1),
  #  breaks = 10^(0:5),
  #  limits = c(NA,10000))+
  guides(colour="none")
  #annotation_logticks(sides="l")
p_a


p_b<-fin_exp_df%>%
  filter(APOBEC=="A3B")%>%
  filter(gene_id=="APOBEC3B")%>%
  ggplot(aes(x=dose,y=mean.TPM,col="black"))+
  geom_bar(stat="identity")+
  #scale_y_log10()+
  theme_classic()+
  geom_errorbar(aes(ymin=mean.TPM-se,ymax=mean.TPM+se))+
  theme(axis.title=element_text(size=40,face="bold"),
        axis.text=element_text(size=35),
        strip.text=element_text(size=35,face="italic"),
        strip.background=element_blank(),
        legend.text=element_text(size=30),
        legend.title=element_text(size=30),
        axis.ticks.y=element_line(size=2),
        axis.ticks.x=element_line(size=2),
        axis.ticks.length.y=unit(5,"mm"),
        axis.ticks.length.x=unit(3,"mm"),
        legend.position="none",
        legend.key = element_rect(color="black"),
        legend.key.size = unit(1, 'cm')
        #        panel.background=element_rect(fill=NA,color="black"),
        #        panel.border = element_rect(fill=NA,color="black")
  )+
  ylab("Expression level ( TPM )")+
  #scale_fill_manual(values = c(c3[3],c3[2]))+

  coord_cartesian(clip = "off")+
  xlab("")+
  scale_colour_manual(values=c("black","black","black"))+
  #scale_y_continuous(
  #  trans = scales::pseudo_log_trans(sigma = 1),
  #  breaks = 10^(0:5),
  #  limits = c(NA,10000))+
#  annotation_logticks(sides="l")#+
  guides(colour="black")
p_a
p_b
ggsave("/home/users/ayh/Projects/27_A3B/07_revision/expression_levels/A3A.exp.v2.pdf",p_a,
       height=10,width=8)
ggsave("/home/users/ayh/Projects/27_A3B/07_revision/expression_levels/A3B.exp.v2.pdf",p_b,
       height=10,width=8)
p_b

p_a_base<-fin_exp_df%>%
  filter(APOBEC=="A3A")%>%
  filter(gene_id=="APOBEC3A")%>%
  ggplot(aes(x=dose,y=mean.TPM,col="black"))+
  geom_bar(stat="identity")+
  #scale_y_log10()+
  theme_classic()+
  geom_errorbar(aes(ymin=mean.TPM-se,ymax=mean.TPM-se))+
  theme(axis.title=element_text(size=40,face="bold"),
        axis.text=element_text(size=35),
        strip.text=element_text(size=35,face="italic"),
        strip.background=element_blank(),
        legend.text=element_text(size=30),
        legend.title=element_text(size=30),
        axis.ticks.y=element_line(size=2),
        axis.ticks.x=element_line(size=2),
        axis.ticks.length.y=unit(5,"mm"),
        axis.ticks.length.x=unit(3,"mm"),
        legend.position="none",
        legend.key = element_rect(color="black"),
        legend.key.size = unit(1, 'cm')
        #        panel.background=element_rect(fill=NA,color="black"),
        #        panel.border = element_rect(fill=NA,color="black")
  )+
  ylab("Expression level ( TPM )")+
  #scale_fill_manual(values = c(c3[3],c3[2]))+

  coord_cartesian(clip = "off")+
  xlab("")+
  scale_colour_manual(values=c("black","black","black"))+
  #scale_y_continuous(
  #  trans = scales::pseudo_log_trans(sigma = 1),
  #  breaks = 10^(0:5),
  #  limits = c(NA,10000))+
  #  annotation_logticks(sides="l")#+
  guides(colour="black")+
  ylim(c(0,20))


p_a_base

ggsave("/home/users/ayh/Projects/27_A3B/07_revision/expression_levels/A3A.exp.base.v2.pdf",p_a_base,
       height=10,width=8)

p_b_base<-fin_exp_df%>%
  filter(APOBEC=="A3B")%>%
  filter(gene_id=="APOBEC3B")%>%
  ggplot(aes(x=dose,y=mean.TPM,col="black"))+
  geom_bar(stat="identity")+
  #scale_y_log10()+
  theme_classic()+
  geom_errorbar(aes(ymin=mean.TPM-se,ymax=mean.TPM+se))+
  theme(axis.title=element_text(size=40,face="bold"),
        axis.text=element_text(size=35),
        strip.text=element_text(size=35,face="italic"),
        strip.background=element_blank(),
        legend.text=element_text(size=30),
        legend.title=element_text(size=30),
        axis.ticks.y=element_line(size=2),
        axis.ticks.x=element_line(size=2),
        axis.ticks.length.y=unit(5,"mm"),
        axis.ticks.length.x=unit(3,"mm"),
        legend.position="none",
        legend.key = element_rect(color="black"),
        legend.key.size = unit(1, 'cm')
        #        panel.background=element_rect(fill=NA,color="black"),
        #        panel.border = element_rect(fill=NA,color="black")
  )+
  ylab("Expression level ( TPM )")+
  #scale_fill_manual(values = c(c3[3],c3[2]))+

  coord_cartesian(clip = "off")+
  xlab("")+
  scale_colour_manual(values=c("black","black","black"))+
  #scale_y_continuous(
  #  trans = scales::pseudo_log_trans(sigma = 1),
  #  breaks = 10^(0:5),
  #  limits = c(NA,10000))+
  #  annotation_logticks(sides="l")#+
  guides(colour="black")+
  ylim(c(0,20))

ggsave("/home/users/ayh/Projects/27_A3B/07_revision/expression_levels/A3B.exp.base.v2.pdf",p_b_base,
       height=10,width=8)

##additional sample###
######################
exp_files<-list.files("/home/users/ayh/Projects/27_A3B/03_sequencing/single_clone_sequencing/WTS/08_A3B_A3A",
                      "genes.results",
                      full.names=T)

exp_files<-exp_files[(grepl("A3B_1st_C5",exp_files)|grepl("A3A_1st_C3",exp_files))&!(grepl("TP53",exp_files)|grepl("Ctrl",exp_files))]
exp_files

exp_files<-exp_files[!basename(exp_files)%in%c("A3A_1st_C3_48h_3ug.genes.results")]
exp_files<-exp_files[(!grepl("Ctrl",exp_files))]


exp_tmp<-lapply(exp_files,function(x){
  read_tsv(x)%>%mutate(gene_id=gsub("ENSG.*_","",gene_id))%>%
    mutate(id=gsub(".genes.*","",basename(x)))%>%
    mutate(TP53=ifelse(grepl("TP53",id),"KO","WT"))%>%
    mutate(dose=ifelse(grepl("3ug",id),"3ug",
                       ifelse(grepl("100ng_ctrl",id),"100ng",
                              ifelse(grepl("Ctrl",id)|grepl("ctrl",id)|grepl("0h",id),"CTRL","100ng"))))%>%
    mutate(time=ifelse(grepl("48h",id),"48h",
                       ifelse(grepl("36h",id),"36h",
                              ifelse(grepl("24h",id),"24h",
                                     ifelse(grepl("12h",id),"12h","0h")))))%>%
    select(gene_id,TPM,id,TP53,dose,time)
}
)

exp_df<-do.call(rbind,exp_tmp)
exp_df<-exp_df%>%mutate(info=paste(time,dose,sep="_"))

exp_df$dose<-factor(exp_df$dose,levels=c("CTRL","100ng","3ug"))
exp_df$TP53<-factor(exp_df$TP53,levels=c("WT","KO"))



exp_df<-exp_df%>%mutate(APOBEC=ifelse(grepl("A3A",id),"A3A","A3B"))
exp_df%>%filter(gene_id=="APOBEC3B")%>%filter(APOBEC=="A3B")
exp_df
APOBEC_ci_df<-exp_df%>%
  filter(gene_id=="APOBEC3A"|gene_id=="APOBEC3B")%>%
  group_by(APOBEC,gene_id,TP53,dose,info) %>%
  summarise(mean.TPM = mean(TPM, na.rm = TRUE),
            sd.TPM = sd(TPM, na.rm = TRUE),
            n.TPM = n(),
            se=sd.TPM/sqrt(n.TPM))%>%
  mutate(dse=0.434/mean.TPM*se)
APOBEC_ci_df
fin_exp_df<-left_join(exp_df%>%
                        filter(gene_id=="APOBEC3A"|gene_id=="APOBEC3B")%>%
                        group_by(APOBEC,gene_id,TP53,dose,info) %>%
                        summarise(mean.TPM = mean(TPM), na.rm = TRUE),
                      APOBEC_ci_df)%>%
  mutate(max.TPM=mean.TPM+se,
         min.TPM=mean.TPM-se)


p_b_others<-fin_exp_df%>%
  filter(APOBEC=="A3B")%>%
  filter(gene_id=="APOBEC3B")%>%
  ggplot(aes(x=info,y=mean.TPM,col="black"))+
  geom_bar(stat="identity")+
  #scale_y_log10()+
  theme_classic()+
  geom_errorbar(aes(ymin=mean.TPM-se,ymax=mean.TPM+se))+
  theme(axis.title=element_text(size=40,face="bold"),
        axis.text=element_text(size=35),
        strip.text=element_text(size=35,face="italic"),
        strip.background=element_blank(),
        legend.text=element_text(size=30),
        legend.title=element_text(size=30),
        axis.ticks.y=element_line(size=2),
        axis.ticks.x=element_line(size=2),
        axis.ticks.length.y=unit(5,"mm"),
        axis.ticks.length.x=unit(3,"mm"),
        legend.position="none",
        legend.key = element_rect(color="black"),
        legend.key.size = unit(1, 'cm')
        #        panel.background=element_rect(fill=NA,color="black"),
        #        panel.border = element_rect(fill=NA,color="black")
  )+
  ylab("Expression level ( TPM )")+
  ylim(c(0,7000))
  #scale_fill_manual(values = c(c3[3],c3[2]))+

  coord_cartesian(clip = "off")+
  xlab("")+
  scale_colour_manual(values=c("black","black","black"))+
  #scale_y_continuous(
  #  trans = scales::pseudo_log_trans(sigma = 1),
  #  breaks = 10^(0:5),
  #  limits = c(NA,10000))+
  #  annotation_logticks(sides="l")#+
  guides(colour="black")
p_b_others
APOBEC_ci_df%>%
  write.table("/home/users/ayh/Projects/27_A3B/07_revision/expression_levels/exp_table.txt",
              sep="\t",
              quote=F,
              row.names=F,
              )
ggsave("/home/users/ayh/Projects/27_A3B/07_revision/expression_levels/A3B.exp.interval.v2.pdf",p_b_others,
       height=10,width=8)



##additional sample_dose###
######################
exp_files<-list.files("/home/users/ayh/Projects/27_A3B/03_sequencing/single_clone_sequencing/WTS/08_A3B_A3A/A3B_dose",
                      "genes.results",
                      full.names=T)


exp_files



exp_tmp<-lapply(exp_files,function(x){
  read_tsv(x)%>%mutate(gene_id=gsub("ENSG.*_","",gene_id))%>%
    mutate(id=gsub(".genes.*","",basename(x)))%>%
    mutate(TP53=ifelse(grepl("TP53",id),"KO","WT"))%>%
    mutate(dose=ifelse(grepl("0h",id),"0ng/ml",
                       ifelse(grepl("0.001ng",id),"0.001ng/ml",
                              ifelse(grepl("0.01ng",id),"0.01ng/ml",
                                     ifelse(grepl("0.1ng",id),"0.1ng/ml",
                                            ifelse(grepl("0.33ng",id),"0.33ng/ml",
                                                   ifelse(grepl("1ng",id),"1ng/ml",
                                                          ifelse(grepl("33ng",id),"33ng/ml","100ng/ml"))))))))%>%

    mutate(time="48h")%>%
    select(gene_id,TPM,id,TP53,dose,time)
}
)

exp_df<-do.call(rbind,exp_tmp)
exp_df<-exp_df%>%mutate(info=paste(time,dose,sep="_"))

info_dose_order<-c(
  "0ng/ml",
  "0.001ng/ml",
  "0.01ng/ml",
  "0.1ng/ml",
  "0.33ng/ml",
  "1ng/ml",
  "33ng/ml",
  "100ng/ml"
)
info_order<-c(
  "0h_100ng/ml",
  "12h_100ng/ml",
  "24h_100ng/ml",
  "36h_100ng/ml",
  "48h_3ug/ml",
  "48h_0ng/ml",
  "48h_0.001ng/ml",
  "48h_0.01ng/ml",
  "48h_0.1ng/ml",
  "48h_0.33ng/ml",
  "48h_1ng/ml",
  "48h_33ng/ml",
  "48h_100ng/ml"
)
exp_df$dose<-factor(exp_df$dose,levels=info_dose_order)
exp_df$info<-factor(exp_df$info,levels=info_order)
exp_df$TP53<-factor(exp_df$TP53,levels=c("WT","KO"))



exp_df<-exp_df%>%mutate(APOBEC=ifelse(grepl("A3A",id),"A3A","A3B"))
exp_df%>%filter(gene_id=="APOBEC3B")%>%filter(APOBEC=="A3B")
exp_df
APOBEC_ci_df<-exp_df%>%
  filter(gene_id=="APOBEC3A"|gene_id=="APOBEC3B")%>%
  group_by(APOBEC,gene_id,TP53,dose,info) %>%
  summarise(mean.TPM = mean(TPM, na.rm = TRUE),
            sd.TPM = sd(TPM, na.rm = TRUE),
            n.TPM = n(),
            se=sd.TPM/sqrt(n.TPM))%>%
  mutate(dse=0.434/mean.TPM*se)
APOBEC_ci_df
fin_exp_df<-left_join(exp_df%>%
                        filter(gene_id=="APOBEC3A"|gene_id=="APOBEC3B")%>%
                        group_by(APOBEC,gene_id,TP53,dose,info) %>%
                        summarise(mean.TPM = mean(TPM), na.rm = TRUE),
                      APOBEC_ci_df)%>%
  mutate(max.TPM=mean.TPM+se,
         min.TPM=mean.TPM-se)


p_b_dose<-fin_exp_df%>%filter(dose%in%c("0ng/ml","1ng/ml","33ng/ml","100ng/ml"))%>%
  filter(APOBEC=="A3B")%>%
  filter(gene_id=="APOBEC3B")%>%
  ggplot(aes(x=info,y=mean.TPM,col="black"))+
  geom_bar(stat="identity")+
  #scale_y_log10()+
  theme_classic()+
  geom_errorbar(aes(ymin=mean.TPM-se,ymax=mean.TPM+se))+
  theme(axis.title=element_text(size=40,face="bold"),
        axis.text=element_text(size=35),
        strip.text=element_text(size=35,face="italic"),
        strip.background=element_blank(),
        legend.text=element_text(size=30),
        legend.title=element_text(size=30),
        axis.ticks.y=element_line(size=2),
        axis.ticks.x=element_line(size=2),
        axis.ticks.length.y=unit(5,"mm"),
        axis.ticks.length.x=unit(3,"mm"),
        legend.position="none",
        legend.key = element_rect(color="black"),
        legend.key.size = unit(1, 'cm')
        #        panel.background=element_rect(fill=NA,color="black"),
        #        panel.border = element_rect(fill=NA,color="black")
  )+
  ylab("Expression level ( TPM )")+
  #scale_fill_manual(values = c(c3[3],c3[2]))+

  coord_cartesian(clip = "off")+
  xlab("")+
  scale_colour_manual(values=c("black","black","black"))+
  #scale_y_continuous(
  #  trans = scales::pseudo_log_trans(sigma = 1),
  #  breaks = 10^(0:5),
  #  limits = c(NA,10000))+
  #  annotation_logticks(sides="l")#+
  guides(colour="black")


p_b_dose


APOBEC_ci_df%>%
  write.table("/home/users/ayh/Projects/27_A3B/07_revision/expression_levels/exp_table.dose.txt",
              sep="\t",
              quote=F,
              row.names=F,
  )
ggsave("/home/users/ayh/Projects/27_A3B/07_revision/expression_levels/A3B.exp.dose.pdf",p_b_dose,
       height=10,width=8)




p_b_dose_base<-fin_exp_df%>%filter(dose%in%c("0ng/ml","1ng/ml","33ng/ml","100ng/ml"))%>%
  filter(APOBEC=="A3B")%>%
  filter(gene_id=="APOBEC3B")%>%
  ggplot(aes(x=info,y=mean.TPM,col="black"))+
  geom_bar(stat="identity")+
  #scale_y_log10()+
  theme_classic()+
  geom_errorbar(aes(ymin=mean.TPM-se,ymax=mean.TPM+se))+
  theme(axis.title=element_text(size=40,face="bold"),
        axis.text=element_text(size=35),
        strip.text=element_text(size=35,face="italic"),
        strip.background=element_blank(),
        legend.text=element_text(size=30),
        legend.title=element_text(size=30),
        axis.ticks.y=element_line(size=2),
        axis.ticks.x=element_line(size=2),
        axis.ticks.length.y=unit(5,"mm"),
        axis.ticks.length.x=unit(3,"mm"),
        legend.position="none",
        legend.key = element_rect(color="black"),
        legend.key.size = unit(1, 'cm')
        #        panel.background=element_rect(fill=NA,color="black"),
        #        panel.border = element_rect(fill=NA,color="black")
  )+
  ylab("Expression level ( TPM )")+
  #scale_fill_manual(values = c(c3[3],c3[2]))+

  coord_cartesian(clip = "off")+
  xlab("")+
  scale_colour_manual(values=c("black","black","black"))+
  #scale_y_continuous(
  #  trans = scales::pseudo_log_trans(sigma = 1),
  #  breaks = 10^(0:5),
  #  limits = c(NA,10000))+
  #  annotation_logticks(sides="l")#+
  guides(colour="black")+
  ylim(c(0,60))
p_b_dose_base


ggsave("/home/users/ayh/Projects/27_A3B/07_revision/expression_levels/A3B.exp.dose.base.pdf",p_b_dose_base,
       height=10,width=8)

###A3A additional##
###################


exp_files<-list.files("/home/users/ayh/Projects/27_A3B/03_sequencing/single_clone_sequencing/WTS/08_A3B_A3A/A3A_time/",
                      "genes.results",
                      full.names=T)

exp_files<-exp_files[(grepl("A3B_1st_C5",exp_files)|grepl("A3A_1st_C3",exp_files))&!(grepl("TP53",exp_files))]


exp_files<-exp_files[!basename(exp_files)%in%c("A3A_1st_C3_48h_3ug.genes.results")]
#exp_files<-exp_files[(!grepl("Ctrl",exp_files))]


exp_tmp<-lapply(exp_files,function(x){
  read_tsv(x)%>%mutate(gene_id=gsub("ENSG.*_","",gene_id))%>%
    mutate(id=gsub(".genes.*","",basename(x)))%>%
    mutate(TP53=ifelse(grepl("TP53",id),"KO","WT"))%>%
    mutate(dose=ifelse(grepl("3ug",id),"3ug/ml",
                       ifelse(grepl("100ng_ctrl",id),"100ng/ml",
                              ifelse(grepl("Ctrl",id)|grepl("ctrl",id)|grepl("0h",id),"0ng/ml","100ng/ml"))))%>%
    mutate(time=ifelse(grepl("12h",id),"12h",
                             ifelse(grepl("24h",id),"24h",
                                    ifelse(grepl("36h",id),"36h",
                                           ifelse(grepl("Ctrl",id),"0h","48h")))))%>%
    select(gene_id,TPM,id,TP53,dose,time)
}
)

exp_df<-do.call(rbind,exp_tmp)
exp_df<-exp_df%>%mutate(info=paste(time,dose,sep="_"))
exp_df$info%>%unique()
info_order<-c(
  "0h_0ng/ml",
  "12h_100ng/ml",
  "24h_100ng/ml",
  "36h_100ng/ml",
  "48h_100ng/ml",
  "48h_3ug/ml",
  "48h_0ng/ml",
  "48h_0.001ng/ml",
  "48h_0.01ng/ml",
  "48h_0.1ng/ml",
  "48h_0.33ng/ml",
  "48h_1ng/ml",
  "48h_33ng/ml"

)
#exp_df$dose<-factor(exp_df$dose,levels=info_dose_order)
exp_df$info<-factor(exp_df$info,levels=info_order)
exp_df$TP53<-factor(exp_df$TP53,levels=c("WT","KO"))


#exp_df$dose<-factor(exp_df$dose,levels=c("CTRL","100ng","3ug"))
exp_df$TP53<-factor(exp_df$TP53,levels=c("WT","KO"))



exp_df<-exp_df%>%mutate(APOBEC=ifelse(grepl("A3A",id),"A3A","A3B"))


APOBEC_ci_df<-exp_df%>%
  filter(gene_id=="APOBEC3A"|gene_id=="APOBEC3B")%>%
  group_by(APOBEC,gene_id,TP53,dose) %>%
  summarise(mean.TPM = mean(TPM, na.rm = TRUE),
            sd.TPM = sd(TPM, na.rm = TRUE),
            n.TPM = n(),
            se=sd.TPM/sqrt(n.TPM))%>%
  mutate(dse=0.434/mean.TPM*se)

fin_exp_df<-left_join(exp_df%>%
                        filter(gene_id=="APOBEC3A"|gene_id=="APOBEC3B")%>%
                        group_by(APOBEC,gene_id,TP53,dose,time,info) %>%
                        summarise(mean.TPM = mean(TPM), na.rm = TRUE),
                      APOBEC_ci_df)%>%
  mutate(max.TPM=mean.TPM+se,
         min.TPM=mean.TPM-se)



A3A_p_df<-exp_df%>%
  filter(gene_id=="APOBEC3A"|gene_id=="APOBEC3B")%>%
  filter(APOBEC=="A3A")%>%
  filter(gene_id=="APOBEC3A")%>%
  #group_by(dose)%>%
  rstatix::t_test(TPM~dose,p.adjust.method ="BH")%>%
  rstatix::add_significance()%>%
  rstatix::add_xy_position()

A3A_p_df

p_a<-fin_exp_df%>%
  filter(APOBEC=="A3A")%>%
  filter(gene_id=="APOBEC3A")%>%
  ggplot(aes(x=info,y=mean.TPM,col="black"))+
  geom_bar(stat="identity")+
  #scale_y_log10()+
  theme_classic()+
  geom_errorbar(aes(ymin=mean.TPM-se,ymax=mean.TPM+se))+
  theme(axis.title=element_text(size=40,face="bold"),
        axis.text=element_text(size=35),
        strip.text=element_text(size=35,face="italic"),
        strip.background=element_blank(),
        legend.text=element_text(size=30),
        legend.title=element_text(size=30),
        axis.ticks.y=element_line(size=2),
        axis.ticks.x=element_line(size=2),
        axis.ticks.length.y=unit(5,"mm"),
        axis.ticks.length.x=unit(3,"mm"),
        legend.position="none",
        legend.key = element_rect(color="black"),
        legend.key.size = unit(1, 'cm')
        #        panel.background=element_rect(fill=NA,color="black"),
        #        panel.border = element_rect(fill=NA,color="black")
  )+
  ylab("Expression level ( TPM )")+
  #scale_fill_manual(values = c(c3[3],c3[2]))+

  coord_cartesian(clip = "off")+
  xlab("")+
  scale_colour_manual(values=c("black","black","black"))+
  #scale_y_continuous(
  #  trans = scales::pseudo_log_trans(sigma = 1),
  #  breaks = 10^(0:5),
  #  limits = c(NA,10000))+
  guides(colour="none")+
  ylim(c(0,7000))
#annotation_logticks(sides="l")
p_a


ggsave("/home/users/ayh/Projects/27_A3B/07_revision/expression_levels/A3A.exp.time_interval.v2.pdf",p_a,
       height=10,width=8)
