library(dplyr)
library(tidyverse)

depth_df<-read_tsv("/home/users/ayh/Projects/27_A3B/06_Figure_code/edit_figure/Fig2/redit_depth.txt")%>%
  plyr::rename(c("new_id"="id"))
rna_editing_filter_sample_CtoT_df<-read_tsv("/home/users/ayh/Projects/27_A3B/07_revision/RNA_editing/hotspot/RNA_editing.CtoT.tsv")
rna_editing_filter_sample_CtoT_df$new_id%>%unique()
rna_editing_filter_sample_CtoT_df$id%>%unique()

rna_editing_filter_sample_CtoT_depth_df<-left_join(rna_editing_filter_sample_CtoT_df,depth_df)%>%
  mutate(condition=ifelse(grepl("0h",new_id),"0h", ifelse(grepl("100ng",new_id),"0.1ug","3ug")))

rna_editing_CtoT_depth_stat_df<-rna_editing_filter_sample_CtoT_depth_df%>%
  group_by(id,APOBEC,condition,tot_depth)%>%
  dplyr::summarise(n=n())
rna_editing_CtoT_depth_stat_df$condition%>%unique()
rna_editing_CtoT_depth_stat_df$condition<-factor(rna_editing_CtoT_depth_stat_df$condition,levels=c("0h","0.1ug","3ug"))
p_redit_depth_count<-rna_editing_CtoT_depth_stat_df%>%
  ggplot(aes(x=tot_depth,y=n,col=APOBEC,shape=condition))+
  geom_point(size=5)+
  theme_classic()+
  xlim(c(0,15000000000))+
  ylim(c(0,63000))+
  scale_shape_manual(values=c( 16, 17,18))
ggsave("/home/users/ayh/Projects/27_A3B/08_2nd_revision/RNA_editing/redit_depth.pdf", p_redit_depth_count,
       width=10,height=8)


old_rna_editing_filter_sample_CtoT_stat_df<-rna_editing_filter_sample_CtoT_df%>%
  mutate(condition=ifelse(grepl("0h",new_id),"0h", ifelse(grepl("100ng",new_id),"0.1ug","3ug")))%>%
  group_by(APOBEC,info)%>%
  dplyr::summarise(n=n())
  


rna_editing_filter_sample_CtoT_stat_df<-rna_editing_filter_sample_CtoT_df%>%
  mutate(condition=ifelse(grepl("0h",new_id),"0h", ifelse(grepl("100ng",new_id),"0.1ug","3ug")))%>%
  group_by(APOBEC,condition,info)%>%
  dplyr::summarise(n=n())%>%
  spread(condition,n)

rna_editing_filter_sample_CtoT_stat_df[is.na(rna_editing_filter_sample_CtoT_stat_df)]<-0

rna_editing_filter_sample_CtoT_stat_df<-rna_editing_filter_sample_CtoT_stat_df%>%
  mutate(hotspot=ifelse(`0.1ug`+`3ug`>1&`0h`==0,1,
                        ifelse(`0h`>0&`0.1ug`+`3ug`>=1,1,0)))



rna_editing_CtoT_hotspot_df<-rbind(
  rna_editing_filter_sample_CtoT_df%>%
    filter(APOBEC=="A3A")%>%
    filter(info%in%(rna_editing_filter_sample_CtoT_stat_df%>%filter(APOBEC=="A3A")%>%filter(hotspot==1))$info),
  rna_editing_filter_sample_CtoT_df%>%
    filter(APOBEC=="A3B")%>%
    filter(info%in%(rna_editing_filter_sample_CtoT_stat_df%>%filter(APOBEC=="A3B")%>%filter(hotspot==1))$info)
)




#rna_editing_filter_sample_CtoT_df%>%filter(info%in%(rna_editing_filter_sample_CtoT_stat_df%>%filter(n>1))$info)%>%nrow()

#rna_editing_CtoT_hotspot_df<-rna_editing_filter_sample_CtoT_df%>%filter(info%in%(rna_editing_filter_sample_CtoT_stat_df%>%filter(n>1))$info)

rna_editing_CtoT_hotspot_df<-rna_editing_CtoT_hotspot_df%>%mutate(condition=ifelse(grepl("0h",new_id),"0h",
                                                                                   ifelse(grepl("100ng",new_id),"0.1ug","3ug")))

rna_editing_CtoT_hotspot_stat_df<-rna_editing_CtoT_hotspot_df%>%
  group_by(id)%>%
  dplyr::summarise(recur_count=n())

rna_editing_CtoT_depth_stat_sum_df<-left_join(rna_editing_CtoT_depth_stat_df,rna_editing_CtoT_hotspot_stat_df)%>%
  mutate(recur_freq=recur_count/n)

rna_editing_CtoT_depth_stat_sum_df%>%
  write.table("/home/users/ayh/Projects/27_A3B/08_2nd_revision/RNA_editing/redit_depth_recur.txt",
              sep="\t",
              quote=F,
              row.names=F)

p_redit_depth_recur_freq<-rna_editing_CtoT_depth_stat_sum_df%>%
  ggplot(aes(x=tot_depth,y=recur_freq,col=APOBEC,shape=condition))+
  geom_point(size=5)+
  theme_classic()+
  xlim(c(0,15000000000))+
  #ylim(c(0.5,1))+
  scale_shape_manual(values=c(16,17,18))+
  scale_y_continuous(lim=c(0.4,1),
                     breaks=c(0.4,0.6,0.8,1),
                     labels=c("0.4","0.6","0.8","1.0"))


p_redit_depth_recur_freq


ggsave("/home/users/ayh/Projects/27_A3B/08_2nd_revision/RNA_editing/redit_depth_freq.pdf",p_redit_depth_recur_freq,
       width=10,height=8)

