library(dplyr)
library(tidyverse)
library(ggplot2)
#240812
##bin5_excl_intergenic,WT
forestplot2 <- function (labeltext, mean, lower, upper,
                         align = NULL, is.summary = FALSE,
                         fontfamily.summary = NULL, fontfamily.labelrow = NULL,
                         clip = c(-Inf, Inf), xlab = "", zero = 0,
                         graphwidth = unit(51, "mm"), col = meta.colors(),
                         xlog = FALSE, xticks = NULL,
                         increase.line_height = 1.2,
                         lwd.xaxis=NULL,
                         lwd.zero=NULL,
                         lwd.forestlines=NULL,
                         boxsize = NULL, ...)
{
  require("grid") || stop("`grid' package not found")
  require("rmeta") || stop("`rmeta' package not found")
  
  # Addon: if two-dimentional mean, lower & upper
  # the two are printed next to eachother
  if (NCOL(mean) == NCOL(lower) && NCOL(lower) == NCOL(upper) && NCOL(mean) > 0){
    org_mean <- mean
    org_lower <- lower
    org_upper <- upper
    if (NCOL(mean) > 1){
      mean <- as.vector(mean)
      lower <- as.vector(lower)
      upper <- as.vector(upper)
    }
  }else{
    stop('Mean, lower and upper contain invalid number of columns')
  }
  # A function that is used to draw the different confidence intervals
  drawNormalCI <- function(LL, OR, UL, size, y.offset = 0.5, clr.line, clr.box) {
    size = 0.75 * size
    
    # Check if line/box outside graph
    clipupper <- convertX(unit(UL, "native"), "npc", valueOnly = TRUE) >
      1
    cliplower <- convertX(unit(LL, "native"), "npc", valueOnly = TRUE) <
      0
    box <- convertX(unit(OR, "native"), "npc", valueOnly = TRUE)
    clipbox <- box < 0 || box > 1
    
    # A version where arrows are added to the part outside
    # the limits of the graph
    if (clipupper || cliplower) {
      ends <- "both"
      lims <- unit(c(0, 1), c("npc", "npc"))
      if (!clipupper) {
        ends <- "first"
        lims <- unit(c(0, UL), c("npc", "native"))
      }
      if (!cliplower) {
        ends <- "last"
        lims <- unit(c(LL, 1), c("native", "npc"))
      }
      grid.lines(x = lims, y = y.offset, arrow = arrow(ends = ends,
                                                       length = unit(0.05, "inches")), gp = gpar(col = clr.line, lwd=lwd.forestlines))
      if (!clipbox)
        grid.rect(x = unit(OR, "native"), y=y.offset, width = unit(size,
                                                                   "snpc"), height = unit(size, "snpc"), gp = gpar(fill = clr.box,
                                                                                                                   col = clr.box))
    }
    else {
      grid.lines(x = unit(c(LL, UL), "native"), y = y.offset,
                 gp = gpar(col = clr.line, lwd=lwd.forestlines))
      grid.rect(x = unit(OR, "native"), y=y.offset, width = unit(size,
                                                                 "snpc"), height = unit(size, "snpc"), gp = gpar(fill = clr.box,
                                                                                                                 col = clr.box))
      if ((convertX(unit(OR, "native") + unit(0.5 * size,
                                              "lines"), "native", valueOnly = TRUE) > UL) &&
          (convertX(unit(OR, "native") - unit(0.5 * size,
                                              "lines"), "native", valueOnly = TRUE) < LL))
        grid.lines(x = unit(c(LL, UL), "native"), y = 0.5,
                   gp = gpar(col = clr.line, lwd=lwd.forestlines))
    }
  }
  drawSummaryCI <- function(LL, OR, UL, size) {
    grid.polygon(x = unit(c(LL, OR, UL, OR), "native"), y = unit(0.5 +
                                                                   c(0, 0.5 * size, 0, -0.5 * size), "npc"), gp = gpar(fill = col$summary,
                                                                                                                       col = col$summary))
  }
  
  # A function used for fetching the text or expression
  # from the supplied labeltext.
  fetchRowLabel <- function(label_type, labeltext, i, j){
    if (label_type=="expression"){
      # Haven't figured out it this is possible with
      # a multilevel expression
      row_column_text <- labeltext[[i]]
    }
    else if(label_type=="list"){
      # I get annoying warnings with this
      #if (!is.expression(labeltext[[j]][[i]]) && is.na(labeltext[[j]][[i]]))
      #    return(FALSE)
      row_column_text <- labeltext[[j]][[i]]
    }
    else{
      if (is.na(labeltext[i, j]))
        return(FALSE)
      row_column_text <- labeltext[i, j]
    }
    return(row_column_text)
  }
  validateLabelList <- function(labelList){
    l = length(labelList[[1]])
    if (length(labelList) == 1)
      return(TRUE)
    
    for(i in 1:length(labelList)){
      # All elements should have the same length
      if (l != length(labelList[[i]]))
        return(FALSE)
    }
    
    return(TRUE)
  }
  
  # The previous algorithm failed when I added the expressions
  findWidestGrob <- function (grob.list){
    len <- c()
    for (i in 1:(length(grob.list))){
      if (is.object(grob.list[[i]])){
        # There is a tendency of underestemating grob size
        # when there are expressions
        mm <- convertWidth(grobWidth(grob.list[[i]]), "mm")
        len <- append(len, mm)
      }else{
        len <- append(len, 0)
      }
    }
    
    return(unit(max(len), "mm"))
  }
  
  # Workaround for expressions
  if (is.expression(labeltext)){
    widthcolumn <- c(TRUE)
    # Can't figure out multiple levels of expressions
    nc <- 1
    nr <- length(labeltext)
    label_type = "expression"
  }else if(is.list(labeltext)){
    if (validateLabelList(labeltext) == FALSE)
      stop("Invalid labellist, it has to be formed as a matrix m x n elements")
    
    # Can't figure out multiple levels of expressions
    nc <- length(labeltext)
    
    # Works but probably not as orig. intended
    widthcolumn <- rep(TRUE, nc)
    
    nr <- length(labeltext[[1]])
    label_type = "list"
  }else{
    # Original code for matrixes
    widthcolumn <- !apply(is.na(labeltext), 1, any)
    nc <- NCOL(labeltext)
    nr <- NROW(labeltext)
    label_type = "matrix"
  }
  
  # Prepare the summary and align variables
  if (is.null(align)){
    align <- c("l", rep("r", nc - 1))
  } else {
    align <- rep(align, length = nc)
  }
  
  is.summary <- rep(is.summary, length = nr)
  
  getLabels <- function(){
    labels <- vector("list", nc)
    
    # Walk through the labeltext
    # Creates a list matrix with
    # The column part
    for (j in 1:nc) {
      labels[[j]] <- vector("list", nr)
      
      # The row part
      for (i in 1:nr) {
        txt_out <- fetchRowLabel(label_type, labeltext, i, j)
        if (is.expression(txt_out) || is.character(txt_out) || is.numeric(txt_out)){
          x <- switch(align[j], l = 0, r = 1, c = 0.5)
          
          just <- switch(align[j],
                         l = "left",
                         r = "right",
                         c = "center")
          
          # Bold the text if this is a summary
          if (is.summary[i]){
            if (is.expression(txt_out)){
              x <- 0.5
            }else{
              x <- 0
            }
            # Create a textGrob for the summary
            labels[[j]][[i]] <- textGrob(txt_out, x = x,
                                         just = just,
                                         hjust = 0,
                                         gp = gpar(fontface = "bold",
                                                   fontfamily=fontfamily.summary,
                                                   cex = 1.3,
                                                   col = rep(col$text, length = nr)[i]))
          }else{
            # Create a textGrob with the current row-cell for the label
            labels[[j]][[i]] <- textGrob(txt_out, x = x,
                                         just = just,
                                         gp = gpar(fontface = "plain",
                                                   fontfamily=fontfamily.labelrow,
                                                   col = rep(col$text, length = nr)[i]))
          }
        }
      }
    }
    return(labels)
  }
  labels <- getLabels()
  
  # Set the gap between columns
  colgap <- unit(6, "mm")
  
  # There is always at least one column so grab the widest one
  # and have that as the base for the column widths
  colwidths <- unit.c(findWidestGrob(labels[[1]]), colgap)
  
  # If multiple row label columns, add the other column widths
  if (nc > 1) {
    for (i in 2:nc){
      colwidths <- unit.c(colwidths,
                          findWidestGrob(labels[[i]][widthcolumn]),
                          colgap)
    }
  }
  
  # Add the base grapwh width to the total column width
  # default is 2 inches
  colwidths <- unit.c(colwidths, graphwidth)
  
  # Create the canvas for the plot
  plot.new()
  
  # The base viewport, set the increase.line_height paremeter if it seems a little
  # crowded between the lines that might happen when having multiple comparisons
  pushViewport(viewport(layout = grid.layout(nr + 1, length(colwidths),
                                             widths = colwidths,
                                             heights = unit(c(rep(1, nr), 0.5)*increase.line_height, "lines"))))
  
  # Get width of the lines
  cwidth <- (upper - lower)
  
  # If the borders are smaller than the upper/lower limits
  # then clip the graph. The line will have arrows indicating
  # that it continues beyond the graph
  # The zero bar has to be on the chart though!
  xrange <- c(min(zero, max(min(lower, na.rm = TRUE), clip[1])), max(min(max(upper,
                                                                             na.rm = TRUE), clip[2]), zero))
  
  # Create the fourth argument 4 the drawNormalCI() function
  
  # If boxsize was provided override the info
  if (!is.null(boxsize)){
    # If matrix is provided this will convert it
    # to a vector but it doesn't matter in this case
    info <- rep(boxsize, length = length(cwidth))
  }else{
    info <- 1/cwidth
    info <- info/max(info[!is.summary], na.rm = TRUE)
    info[is.summary] <- 1
  }
  
  printLabels <- function(){
    # Output the labels
    # The column
    for (j in 1:nc) {
      # The row
      for (i in 1:nr) {
        if (!is.null(labels[[j]][[i]])) {
          # The column position is 2 * j - 1 due to the column gap
          pushViewport(viewport(layout.pos.row = i,
                                layout.pos.col = 2 * j - 1))
          grid.draw(labels[[j]][[i]])
          popViewport()
        }
      }
    }
  }
  printLabels()
  
  pushViewport(viewport(layout.pos.col = 2 * nc + 1, xscale = xrange))
  
  # Print y-axis - the vertical "zero" axis
  grid.lines(x = unit(zero, "native"), y = 0:1, gp = gpar(col = col$zero, lwd=lwd.zero))
  
  # Print x-axis
  if (xlog) {
    if (is.null(xticks)) {
      ticks <- pretty(exp(xrange))
      ticks <- ticks[ticks > 0]
    }
    else {
      ticks <- xticks
    }
    if (length(ticks)) {
      if (min(lower, na.rm = TRUE) < clip[1])
        ticks <- c(exp(clip[1]), ticks)
      if (max(upper, na.rm = TRUE) > clip[2])
        ticks <- c(ticks, exp(clip[2]))
      xax <- xaxisGrob(gp = gpar(cex = 0.6, col = col$axes, lwd=lwd.xaxis),
                       at = log(ticks), name = "xax")
      xax1 <- editGrob(xax, gPath("labels"), label = format(ticks,
                                                            digits = 2))
      grid.draw(xax1)
    }
  } else {
    if (is.null(xticks)) {
      grid.xaxis(gp = gpar(cex = 0.6, col = col$axes, lwd=lwd.xaxis))
    }
    else if (length(xticks)) {
      grid.xaxis(at = xticks, gp = gpar(cex = 0.6, col = col$axes, lwd=lwd.xaxis))
    }
  }
  
  # Write the label for the x-axis
  grid.text(xlab, y = unit(-2, "lines"), gp = gpar(col = col$axes))
  popViewport()
  
  # Output the different confidence intervals
  for (i in 1:nr) {
    if (is.na(mean[i]))
      next
    pushViewport(viewport(layout.pos.row = i, layout.pos.col = 2 *
                            nc + 1, xscale = xrange))
    
    if (is.matrix(org_mean)){
      low_values <- org_lower[i,]
      mean_values <- org_mean[i,]
      up_values <- org_upper[i,]
      info_values <- matrix(info, ncol=length(low_values))[i, ]
    }else{
      low_values <- lower[i]
      mean_values <- mean[i]
      up_values <- upper[i]
      info_values <- info[i]
    }
    
    # The line and box colors may vary
    clr.line <- rep(col$line, length=length(low_values))
    clr.box <- rep(col$box, length=length(low_values))
    if (is.summary[i])
      drawSummaryCI(low_values, mean_values, up_values, info_values)
    else{
      if (length(low_values) > 1){
        y.offset_base <- 0.2
        y.offset_increase <- (1-y.offset_base*2)/length(low_values)
        
        for(j in 1:length(low_values)){
          drawNormalCI(low_values[j],
                       mean_values[j],
                       up_values[j],
                       info_values[j],
                       y.offset = y.offset_base + (j-1)*y.offset_increase,
                       clr.line = clr.line[j],
                       clr.box = clr.box[j])
        }
      }else{
        drawNormalCI(low_values, mean_values, up_values, info_values,
                     clr.line = clr.line, clr.box = clr.box)
      }
    }
    
    
    popViewport()
  }
  popViewport()
}

ref_list_files<-list.files("/home/users/ayh/Projects/27_A3B/03_sequencing/single_clone_sequencing/WGS/28_genomic_feature/06_ref/final/bin5/",
                           "N.tsv",
                           full.names=T)
ref_list_files<-ref_list_files[!grepl("KO",ref_list_files)]

ref_list_files<-ref_list_files[!grepl("RNAseq.own.bin5",ref_list_files)]
ref_list_files
ref_tmp<-lapply(ref_list_files,function(x){
  read_tsv(x,col_names=c("len"),show_col_types=FALSE)%>%
    mutate(seq=gsub("\\..*","",basename(x)))%>%
    mutate(quant=gsub(".*.bin5.","",gsub(".[nonTCN]*.tsv","",basename(x))))%>%
    mutate(cont_type=gsub(".tsv","",gsub(".*q..","",basename(x))))
  
  
})
ref_df<-do.call(rbind,ref_tmp)%>%
  mutate(quant=gsub("q","",quant))


ref_df$seq%>%unique()


A3A_df<-read_tsv("/home/users/ayh/Projects/27_A3B/03_sequencing/single_clone_sequencing/WGS/28_genomic_feature/05_vcf/annotation_total/bin5_tot_excl_intergenic/APOBEC_epi_merge.A3A.spread.tsv")
A3A_df$id%>%unique()
A3A_filter_df<-A3A_df%>%filter((!grepl("Ctrl",id)&!grepl("TP53",id)))

A3A_filter_df
vcf_list_files<-list.files("/home/users/ayh/Projects/27_A3B/03_sequencing/single_clone_sequencing/WGS/24_mutect2_strelka2_baseq/merge/clonal/new_filter/",
                           "excl_common.gd",
                           full.names=T)

vcf_tmp<-lapply(vcf_list_files,function(x){
  read_tsv(x,show_col_types = F)%>%mutate(id=gsub(".mutect2.*","",basename(x)))%>%mutate(TP53=ifelse(grepl("TP53",id),"KO","WT"))%>%mutate(mut_type=substr(sig_cont,2,4))%>%
    select(`#CHROM`,POS,ID,REF,ALT,QUAL,FILTER,INFO,FORMAT,Func_refGene,Gene_refGene,GeneDetail_refGene,ExonicFunc_refGene,cosmic86_coding,TP53,id,sig_cont,mut_type)
})

vcf_df<-do.call(rbind,vcf_tmp)

if(FALSE){
  vcf_df<-vcf_df%>%
    mutate(cont_type=ifelse(grepl("TC>",sig_cont),"TCN",
                            ifelse(grepl("C>",sig_cont),"nonTCN","NTN")))
  
  
  vcf_df%>%
    mutate(cont_type=ifelse(grepl("TC>",sig_cont),"TCN",
                            ifelse(grepl("C>",sig_cont),"nonTCN","NTN")))%>%
    write.table("/home/users/ayh/Projects/27_A3B/03_sequencing/single_clone_sequencing/WGS/28_genomic_feature/01_refernce/fin/v2/mappable/total/total.vcf",
                sep="\t",
                quote=F,
                row.names=F)
}
vcf_df<-read_tsv("/home/users/ayh/Projects/27_A3B/03_sequencing/single_clone_sequencing/WGS/28_genomic_feature/01_refernce/fin/v2/mappable/total/total.vcf")

vcf_df%>%filter(cont_type=="TCN")%>%
  filter(grepl("A3A",id))%>%
  group_by(id)%>%
  dplyr::summarise(n=n())%>%
  print(n=100)
ref_df
A3A_df%>%filter(id=="A3A_1st_C3_100ng-1")

merge_df<-left_join(A3A_df,vcf_df,by=(c("#CHROM"="#CHROM","r2"="POS","id"="id")))%>%
  mutate(mut_type=substr(sig_cont,2,4))

##filter(C>A in TCN context), other CTRL samples
merge_filter_df<-merge_df%>%
  filter(!(mut_type=="C>A"&cont_type=="TCN"))%>%
  filter(!grepl("CTRL",id))%>%
  filter(!grepl("Ctrl",id))


merge_filter_sum_df<-merge_filter_df%>%unique()%>%
  gather(seq,quant,DHS:RNAseq)%>%
  group_by(id,cont_type,seq,quant)%>%
  dplyr::summarise(n=n())

merge_filter_sum_tmp_df<-merge_filter_sum_df%>%
  spread(quant,n)

merge_filter_sum_tmp_df[is.na(merge_filter_sum_tmp_df)]<-0
merge_filter_sum_df<-merge_filter_sum_tmp_df%>%
  gather(quant,n,4:11)
##filter(quant==3 or 4)


ref_merge_filter_df<-merge_filter_sum_df%>%ungroup()%>%
  left_join(ref_df,by=c("seq"="seq","quant"="quant","cont_type"="cont_type"))
ref_merge_filter_df[is.na(ref_merge_filter_df)]<-0

ref_merge_filter_df<-ref_merge_filter_df%>%
  mutate(dose=ifelse(grepl("_3",id),"3ug/ml","0.1ug/ml"))%>%
  mutate(TP53=ifelse(grepl("TP53",id),"KO","WT"))

mappable_df<-read_tsv("/home/users/ayh/Projects/27_A3B/03_sequencing/single_clone_sequencing/WGS/28_genomic_feature/01_refernce/fin/v2/mappable/total/75mer/total.mappable.raw.rh.vcf")%>%
  mutate(cont_type=ifelse(grepl("TC>",sig_cont),"TCN",
                          ifelse(grepl("C>",sig_cont),"nonTCN","NTN")))%>%
  filter(!(mut_type=="C>A"&cont_type=="TCN"))%>%
  unique()%>%
  filter(grepl("A3A",id))%>%
  filter(!grepl("CTRL",id))%>%
  filter(!grepl("Ctrl",id))%>%
  filter(!id%in%c("A3A_1st_C3","A3A_C3_TP53KO_C3"))

if(FALSE){
  mappable_df%>%
    group_by(TP53,cont_type)%>%
    dplyr::summarise(n=n())%>%
    write.table("/home/users/ayh/Projects/27_A3B/03_sequencing/single_clone_sequencing/WGS/28_genomic_feature/01_refernce/fin/v2/mappable/total/75mer/total.mappable.raw.rh.sum.tsv",
                quote=F,
                row.names=F,
                sep="\t")
}
mappable_df$id%>%unique()
mappable_count_df<-mappable_df%>%
  group_by(TP53,cont_type)%>%
  dplyr::summarise(n=n())


mappable_ref_files<-list.files("/home/users/ayh/Projects/27_A3B/03_sequencing/single_clone_sequencing/WGS/28_genomic_feature/01_refernce/fin/v2/mappable/total/75mer/",
                               "*N.txt",
                               full.names=T)
mappable_tmp<-lapply(mappable_ref_files,function(x){
  read_tsv(x,col_names=c("len"))%>%
    mutate(cont_type=gsub(".txt","",gsub("mappable_len.","",basename(x))))
})
mappable_ref_df<-do.call(rbind,mappable_tmp)

ref_merge_filter_df%>%filter(TP53=="WT")%>%select(id)%>%unique()

ref_merge_filter_tot_df<-left_join(ref_merge_filter_df%>%
                                     filter(quant%in%c("1","2","3","4"))%>%
                                     group_by(TP53,id,cont_type,seq)%>%
                                     dplyr::summarise(count_sum=sum(n),
                                                      len_sum=sum(len))%>%
                                     filter(TP53=="WT")%>%
                                     group_by(cont_type,seq)%>%
                                     dplyr::summarise(high_count=sum(count_sum),
                                                      high_len=sum(len_sum)),
                                   ref_merge_filter_df%>%
                                     filter(quant%in%c("0"))%>%
                                     group_by(TP53,id,cont_type,seq)%>%
                                     dplyr::summarise(count_sum=sum(n),
                                                      len_sum=sum(len))%>%
                                     filter(TP53=="WT")%>%
                                     group_by(cont_type,seq)%>%
                                     dplyr::summarise(low_count=sum(count_sum),
                                                      low_len=sum(len_sum))
)

library(fmsb)
library(data.table)

##high####
ref_merge_filter_tot_tmp<-lapply(ref_merge_filter_tot_df$seq%>%unique(),function(x){
  #x="DHS"
  df<-ref_merge_filter_tot_df%>%filter(seq==x)
  
  cont_tmp<-lapply(c("TCN","nonTCN","NTN"),function(y){
    #y="TCN"
    df2<-df%>%filter(cont_type==y)
    rr<-riskratio(X=df2$high_count,
                  m1=df2$high_len,
                  Y=df2$low_count,
                  m2=df2$low_len,
                  conf.level=0.95)
    
    rr
    rr_df<-matrix(c(rr$p.value,rr$estimate,rr$conf.int),nrow=1)%>%
      as.data.table%>%
      setNames(c('p_value','mean','lower_ci','upper_ci')) %>%
      as.tibble()%>%
      mutate(seq=x,cont_type=y)
    #rr_df
    
  })
  cont_rr_df<-do.call(rbind,cont_tmp)
})

rr_tot_df<-do.call(rbind,ref_merge_filter_tot_tmp)
rr_tot_df<-rr_tot_df%>%filter(seq!="rep_dir")
rr_tot_df%>%filter(seq=="RepliSeq")
rr_tot_df<-rr_tot_df%>%filter(seq!="H4K20me1")
TCN_row_names <- list(as.list((rr_tot_df%>%filter(cont_type=="TCN"))$seq),
                      as.list((rr_tot_df%>%filter(cont_type=="TCN"))$cont_type),
                      as.list(format(signif((rr_tot_df%>%filter(cont_type=="TCN"))$p_value,2),scientific=FALSE) %>% paste0('p = ',.)))

rr_tot_df%>%
  select(cont_type,seq,p_value)%>%
  spread(cont_type,p_value)

rr_tot_df%>%
  filter(cont_type=="TCN")

pdf("/home/users/ayh/Projects/27_A3B/06_Figure_code/edit_figure/FigS/epigenome_forest.excl_ingergenic.low_high.log2.pdf")
forestplot2(labeltext=TCN_row_names,
            mean=log2((rr_tot_df%>%filter(cont_type=="TCN"))$mean),
            lower=log2((rr_tot_df%>%filter(cont_type=="TCN"))$lower_ci),
            upper=log2((rr_tot_df%>%filter(cont_type=="TCN"))$upper_ci),
            zero=0,
            #          x
            boxsize=0.3,
            xticks=c(-0.3,0,0.3)
)
dev.off()
##row#####

ref_merge_filter_tot_low_df<-left_join(ref_merge_filter_df%>%
                                         filter(quant%in%c("0"))%>%
                                         group_by(TP53,id,cont_type,seq)%>%
                                         dplyr::summarise(count_sum=sum(n),
                                                          len_sum=sum(len))%>%
                                         filter(TP53=="WT")%>%
                                         group_by(cont_type,seq)%>%
                                         dplyr::summarise(tot_count=sum(count_sum),
                                                          tot_len=sum(len_sum)),
                                       mappable_ref_df%>%mutate(tot_len=10*len)%>%
                                         plyr::rename(c("tot_len"="map_len"))%>%
                                         select(cont_type,map_len)
)%>%
  left_join(mappable_count_df%>%filter(TP53=="WT")%>%plyr::rename(c("n"="map_count"))%>%ungroup()%>%select(-TP53))

ref_merge_filter_tot_low_tmp<-lapply(ref_merge_filter_tot_low_df$seq%>%unique(),function(x){
  #x="DHS"
  df<-ref_merge_filter_tot_low_df%>%filter(seq==x)
  
  cont_tmp<-lapply(c("TCN","nonTCN","NTN"),function(y){
    #y="TCN"
    df2<-df%>%filter(cont_type==y)
    rr<-riskratio(X=df2$tot_count,
                  m1=df2$map_count,
                  Y=df2$tot_len*df2$map_count,
                  m2=df2$map_len*df2$map_count,
                  conf.level=0.95)
    
    
    rr_df<-matrix(c(rr$p.value,rr$estimate,rr$conf.int),nrow=1)%>%
      as.data.table%>%
      setNames(c('p_value','mean','lower_ci','upper_ci')) %>%
      as.tibble()%>%
      mutate(seq=x,cont_type=y)
    #rr_df
    
  })
  cont_rr_df<-do.call(rbind,cont_tmp)
})




rr_tot_low_df<-do.call(rbind,ref_merge_filter_tot_low_tmp)
rr_tot_low_df<-rr_tot_low_df%>%filter(seq!="rep_dir")
rr_tot_low_df%>%filter(seq=="RepliSeq")
rr_tot_low_df<-rr_tot_low_df%>%filter(seq!="H4K20me1")
TCN_row_low_names <- list(as.list((rr_tot_low_df%>%filter(cont_type=="TCN"))$seq),
                          as.list((rr_tot_low_df%>%filter(cont_type=="TCN"))$cont_type),
                          as.list(format(signif((rr_tot_low_df%>%filter(cont_type=="TCN"))$p_value,2),scientific=FALSE) %>% paste0('p = ',.)))


pdf("/home/users/ayh/Projects/27_A3B/06_Figure_code/edit_figure/FigS/epigenome_forest.excl_ingergenic.low.v2.pdf")
forestplot2(labeltext=TCN_row_low_names,
            mean=(rr_tot_low_df%>%filter(cont_type=="TCN"))$mean,
            lower=(rr_tot_low_df%>%filter(cont_type=="TCN"))$lower_ci,
            upper=(rr_tot_low_df%>%filter(cont_type=="TCN"))$upper_ci,
            zero=0,
            #          x
            boxsize=0.3,
            xticks=c(0,0.5,1,1.5)
)
dev.off()

rr_tot_low_df%>%
  filter(cont_type=="TCN")
rbind(
  rr_tot_df%>%mutate(level="high"),
  rr_tot_low_df%>%mutate(level="low")
)%>%
  select(seq,cont_type,level,p_value)%>%
  mutate(p_val_sim=ifelse(p_value<0.05,"*","n.s."))%>%
  select(-p_value)%>%
  spread(cont_type,p_val_sim)%>%print(n=100)

rbind(
  rr_tot_df%>%mutate(level="high"),
  rr_tot_low_df%>%mutate(level="low")
)%>%
  mutate(p_val_sim=ifelse(p_value<0.05,"*","n.s."))%>%
  arrange(cont_type,seq,level)%>%
  select(cont_type,seq,level,mean,lower_ci,upper_ci,p_value,p_val_sim)%>%
  write.table("/home/users/ayh/Projects/27_A3B/06_Figure_code/edit_figure/Fig4/240214_enrichment/enrich.excl_intergenic.jolim_ver.tsv",
              sep="\t",
              quote=F,
              row.names=F)


rbind(
  ref_merge_filter_tot_df%>%mutate(TP53="WT",class="high"),
  ref_merge_filter_tot_low_df%>%mutate(TP53="WT",class="low")
)%>%
  write.table("/home/users/ayh/Projects/27_A3B/06_Figure_code/edit_figure/Fig4/240214_enrichment/enrich.raw.high_low.excl_intergenic.jolim_ver.tsv",
              sep="\t",
              quote=F,
              row.names=F)


left_join(ref_merge_filter_df%>%
            filter(quant!=".")%>%
            group_by(quant,TP53,id,cont_type,seq)%>%
            dplyr::summarise(count_sum=sum(n),
                             len_sum=sum(len))%>%
            filter(TP53=="WT")%>%
            group_by(quant,cont_type,seq)%>%
            dplyr::summarise(tot_count=sum(count_sum),
                             tot_len=sum(len_sum)),
          mappable_ref_df%>%mutate(tot_len=10*len)%>%
            plyr::rename(c("tot_len"="map_len"))%>%
            select(cont_type,map_len)
)%>%
  left_join(mappable_count_df%>%filter(TP53=="WT")%>%plyr::rename(c("n"="map_count"))%>%ungroup())%>%
  write.table("/home/users/ayh/Projects/27_A3B/06_Figure_code/edit_figure/Fig4/240214_enrichment/enrich.raw.excl_intergenic.jolim_ver.tsv",
              sep="\t",
              quote=F,
              row.names=F)



forest_fin_df<-rbind(
  rr_tot_df%>%mutate(level="high"),
  rr_tot_low_df%>%mutate(level="low")
)%>%
  filter(seq%in%c("RepliSeq","RNAseq","H3K27me3","H3K9me3","H4K20me1"))%>%
  mutate(p_val_sim=ifelse(p_value<0.05,"*","n.s."))%>%
  arrange(seq,level,cont_type)%>%
  
  filter(cont_type=="TCN")
forest_fin_df$seq<-factor(forest_fin_df$seq,levels=c("RepliSeq","RNAseq","H3K27me3","H3K9me3","H4K20me1"))
forest_fin_df<-forest_fin_df%>%arrange(seq)
TCN_fin_row_names<-list(as.list((forest_fin_df%>%mutate(info=paste(seq,level,sep="_")))$info),
                        as.list(forest_fin_df$cont_type),
                        as.list(format(signif(forest_fin_df$p_value,2),scientific = FALSE)%>%paste0('p = ',.)))
dev.off()
pdf("/home/users/ayh/Projects/27_A3B/06_Figure_code/edit_figure/Fig4/240214_enrichment/enrich.excl_intergenic.jolim.pdf",width = 10,height=8)
forestplot2(labeltext=TCN_fin_row_names,
            mean=forest_fin_df$mean,
            lower=forest_fin_df$lower_ci,
            upper=forest_fin_df$upper_ci,
            zero=0,
            boxsize=0.3,
            xticks=c(0,0.5,1,1.5))
#p_forest
dev.off()

forest_fin_log2_df<-forest_fin_df%>%mutate(log2_mean=log2(mean),
                                           log2_lower_ci=log2(lower_ci),
                                           log2_upper_ci=log2(upper_ci))

TCN_fin_row_names<-list(as.list((forest_fin_df%>%mutate(info=paste(seq,level,sep="_")))$info),
                        as.list(forest_fin_df$cont_type),
                        as.list(format(signif(forest_fin_df$p_value,2),scientific = FALSE)%>%paste0('p = ',.)))

pdf("/home/users/ayh/Projects/27_A3B/06_Figure_code/edit_figure/Fig4/240214_enrichment/enrich.excl_intergenic.jolim.log.pdf",p_log_forest,
    height=8,width=10)
forestplot2(labeltext=TCN_fin_row_names,
            mean=forest_fin_log2_df$log2_mean,
            lower=forest_fin_log2_df$log2_lower_ci,
            upper=forest_fin_log2_df$log2_upper_ci,
            zero=-1,
            boxsize=0.3,
            xticks=c(-1,0,1))
dev.off()

##



