library(ggprism)
library(ggpubr)
library(dplyr)
library(ggplot2)
library(tidyverse)
exp_files<-list.files("/home/users/ayh/Projects/27_A3B/03_sequencing/single_clone_sequencing/WTS/08_A3B_A3A",
                      "genes.results",
                      full.names=T)
exp_files
exp_files<-exp_files[((grepl("A3B",basename(exp_files))&grepl("A3B_1st_C5",exp_files))&(grepl("48h",exp_files)|grepl("Ctrl",exp_files)|grepl("0h",exp_files)))|((grepl("A3A",basename(exp_files))&grepl("A3A_1st_C3",exp_files))&(grepl("48h",exp_files)|grepl("Ctrl",exp_files)|grepl("0h",exp_files)))]
exp_files<-exp_files[!(grepl("TP53",exp_files))]
#exp_files<-exp_files[(grepl("A3A",basename(exp_files))&grepl("A3A_1st_C3",exp_files))&(grepl("48h",exp_files)|grepl("Ctrl",exp_files)|grepl("0h",exp_files))]
#exp_files<-exp_files[!basename(exp_files)%in%c("A3A_1st_C3_48h_3ug.genes.results")]
#exp_files<-exp_files[!grepl("100ng_48hr",basename(exp_files))]

exp_tmp<-lapply(exp_files,function(x){
  read_tsv(x)%>%mutate(gene_id=gsub("ENSG.*_","",gene_id))%>%
    mutate(id=gsub(".genes.*","",basename(x)))%>%
    mutate(TP53=ifelse(grepl("TP53",id),"KO","WT"))%>%
    mutate(dose=ifelse(grepl("3ug",id),"3ug",
                       ifelse(grepl("100ng_ctrl",id),"100ng",
                              ifelse(grepl("Ctrl",id)|grepl("ctrl",id)|grepl("0h",id),"CTRL","100ng"))))%>%
    select(gene_id,TPM,id,TP53,dose)
}
)

exp_df<-do.call(rbind,exp_tmp)
exp_df%>%select(id,TP53,dose)%>%unique()
exp_df$dose<-factor(exp_df$dose,levels=c("CTRL","100ng","3ug"))
exp_df$TP53<-factor(exp_df$TP53,levels=c("WT","KO"))
exp_df<-exp_df%>%mutate(APOBEC=ifelse(grepl("A3A",id),"A3A","A3B"))


exp_plot_df<-exp_df%>%#filter(dose%in%c("CTRL","3ug"))%>%
  filter(gene_id%in%c("XRCC4","XRCC5","XRCC6","NHEJ1","RAD50","RAD51","BRCA1","BRCA2"))
exp_plot_df$gene_id<-factor(exp_plot_df$gene_id,levels=c("XRCC4","XRCC5","XRCC6","NHEJ1","RAD50","RAD51","BRCA1","BRCA2"))


p_val_df1<-exp_plot_df%>%
  group_by(APOBEC,gene_id)%>%
  rstatix::t_test(TPM~dose)%>%
  rstatix::adjust_pvalue(method="BH")%>%
  rstatix::add_significance()%>%
  rstatix::add_xy_position()
p_val_df1

p_val_df1$y.position<-c(rep(c(2.3,2.5,2.4),16))


exp_plot_df%>%
  ggplot(aes(x=TP53,y=TPM))+
  geom_boxplot(aes(fill=dose),outlier.shape = NA)+
  geom_point(aes(fill=dose),position=position_jitterdodge())+
  facet_wrap(~gene_id,scales="free",ncol=3)+
  scale_y_continuous(limits = c(0, NA))+
  theme_classic()+
  theme(axis.text=element_text(size=20),
        strip.text=element_text(size=20))+
  stat_pvalue_manual(p_val_df1 , label = "p.adj.signif",size=8,tip.length =0)+
  scale_color_manual(values=c("#E1E1E1","#B6CC7C","#77923B","#000000"))+
  scale_fill_manual(values=c("#E1E1E1","#B6CC7C","#77923B"))

p_A3A_DSB_repair<-exp_plot_df%>%filter(APOBEC=="A3A")%>%
  ggplot(aes(x=dose,y=(TPM)))+
  geom_boxplot(aes(col=dose),outlier.shape = NA)+
  geom_point(aes(col=dose),position=position_jitterdodge())+
  facet_wrap(~gene_id,ncol=4)+
  
  #scale_y_continuous(limits = c(0, NA))+
  theme_bw()+
  theme(axis.text=element_text(size=20),
        strip.text=element_text(size=20))+
  #scale_y_continuous(breaks=c(0,1,2),
  #                   labels=c(0,1,2),
  #                   lim=c(0,2.5)
  #)+
  add_pvalue(p_val_df1%>%filter(APOBEC=="A3A"),tip.length = 0 )+
  scale_y_continuous(trans=scales::pseudo_log_trans(base = 10),
                     breaks=c(0.1,1,10,100,1000),
                     lim=c(0,500))+
  annotation_logticks(sides = "l")  

p_A3A_DSB_repair
exp_plot_df%>%filter(APOBEC=="A3B")%>%arrange(-TPM)
p_A3B_DSB_repair<-exp_plot_df%>%filter(APOBEC=="A3B")%>%
  ggplot(aes(x=dose,y=(TPM)))+
  geom_boxplot(aes(col=dose),outlier.shape = NA)+
  geom_point(aes(col=dose),position=position_jitterdodge())+
  facet_wrap(~gene_id,ncol=4)+
  
  #scale_y_continuous(limits = c(0, NA))+
  theme_bw()+
  theme(axis.text=element_text(size=20),
        strip.text=element_text(size=20))+
  #scale_y_continuous(breaks=c(0,1,2),
  #                   labels=c(0,1,2),
  #                   lim=c(0,2.5)
  #)+
  add_pvalue(p_val_df1%>%filter(APOBEC=="A3A"),tip.length = 0 )+
  scale_y_continuous(trans=scales::pseudo_log_trans(base = 10),
                     breaks=c(0.1,1,10,100,1000),
                     lim=c(0,500))+
  annotation_logticks(sides = "l")  

p_A3B_DSB_repair
#p_A3B_DSB_repair
ggsave("/home/users/ayh/Projects/27_A3B/06_Figure_code/edit_figure/FigS/exp_3ug_A3A_repair.DSB_repair.pdf",p_A3A_DSB_repair,
              height=8,width=10)

ggsave("/home/users/ayh/Projects/27_A3B/06_Figure_code/edit_figure/FigS/exp_3ug_A3B_repair.DSB_repair.pdf",p_A3B_DSB_repair,
       height=8,width=10)

exp_plot_df%>%
  ggplot(aes(x=TP53,y=TPM))+
  geom_boxplot(aes(col=dose),outlier.shape = NA)+
  geom_point(aes(col=dose),position=position_jitterdodge())+
  facet_wrap(~gene_id,scales="free",ncol=3)+
  scale_y_continuous(limits = c(0, NA))+
  theme_classic()+
  theme(axis.text=element_text(size=20),
        strip.text=element_text(size=20))+
  stat_pvalue_manual(p_val_df1 , label = "p.adj.signif",size=8,tip.length =0)+
  scale_color_manual(values=c("#E1E1E1","#B6CC7C","#77923B","#000000"))+
  scale_fill_manual(values=c("#E1E1E1","#B6CC7C","#77923B"))

p_3_2
stat_pvalue_manual(p_val_df2 , label = "p.adj.signif",label.size=8)

#ggsave("/home/users/ayh/Projects/27_A3B/06_Figure_code/edit_figure/FigS/exp_3ug_A3A_repair.pdf",p_3,
#       height=8,width=10)
#ggsave("/home/users/ayh/Projects/27_A3B/06_Figure_code/edit_figure/FigS/exp_3ug_A3A_repair.v2.pdf",p_3_2,
#       height=8,width=10)
#ggsave("/home/users/ayh/Projects/27_A3B/06_Figure_code/edit_figure/FigS/exp_3ug_A3A_repair.v3.pdf",p_3_3,
#       height=8,width=10)


exp_df%>%filter(dose%in%c("CTRL","3ug"))%>%
  filter(gene_id%in%c("APOBEC3A","BRCA1","BRCA2","RAD51","RAD52","PARP1"))%>%
  ggplot(aes(x=TP53,y=TPM,col=dose))+
  geom_boxplot(aes(col=dose))+
  geom_point(position=position_jitterdodge())+
  facet_wrap(~gene_id,scales="free",ncol=3)+
  scale_y_continuous(limits = c(0, NA))+
  theme_classic()+
  theme(axis.text=element_text(size=20),
        strip.text=element_text(size=20))#+
stat_pvalue_manual(p_val_df1 , label = "p.adj.signif",size=8,tip.length =0)+
  stat_pvalue_manual(p_val_df2 , label = "p.adj.signif",label.size=8)

