library(ggplot2)
library(dplyr)
library(tidyverse)
library(plyr)

df<-read_tsv("/home/users/ayh/Projects/27_A3B/06_Figure_code/viability/220522_viability.txt")%>%filter(incl=="O")
df<-left_join(df,df%>%filter(dose=="Control")%>%group_by(APOBEC)%>%dplyr::summarise(base=mean(value)))
df<-df%>%mutate(perc=value/base*100)

stat_df<-ddply(df%>%filter(dose!="Control"),c("APOBEC","dose"),summarise,mean=mean(perc),sd=sd(perc),n=length(perc),se=sd/sqrt(n))
colnames(stat_df)[3]="mean_perc"


stat_df$APOBEC<-factor(stat_df$APOBEC,levels=c("CTRL","A3A","A3B"))
stat_df<-stat_df%>%mutate(dose=ifelse(dose=="100ng/ml","0.1ug/ml","3ug/ml"))
stat_df$dose<-factor(stat_df$dose,levels=c("0.1ug/ml","3ug/ml"))

stat_df<-stat_df%>%mutate(APOBEC=ifelse(APOBEC=="A3A","A3A-OE",
                                        ifelse(APOBEC=="A3B","A3B-OE","CTRL")))
stat_df$APOBEC<-factor(stat_df$APOBEC,levels=c("CTRL","A3A-OE","A3B-OE"))
stat_df<-stat_df%>%mutate(margin=qt(0.95,df=n-1)*se)

p<-ggplot(stat_df,aes(x=dose,y=mean_perc,fill=APOBEC,col=dose))+
  geom_bar(stat="identity",position="dodge")+
  
  #facet_wrap(~APOBEC,scales="free_y")+
  scale_y_continuous(breaks=seq(0,100,by=25),
                     labels=seq(0,100,by=25),
                     limits=c(0,110)
  )+
  theme_classic()+
  geom_errorbar(aes(ymin=mean_perc-se,ymax=mean_perc+se),
                position=position_dodge(0.9),width=0.2)+
  scale_fill_manual(values=c("#a9a9a9","#DC8D8D","#ABDDFB"))+
  #theme_test()+
  theme(axis.title=element_text(size=40),
        axis.text=element_text(size=40),
        strip.text=element_text(size=35),
        legend.position="top",
        strip.background=element_blank(),
        legend.title=element_blank(),
        legend.key.size = unit(1, 'cm'),
        legend.key = element_rect(color="black"),
        legend.text=element_text(size=20),
        axis.ticks.y=element_line(size=2),
        axis.ticks.x=element_line(size=2),
        axis.ticks.length.y=unit(5,"mm"),
        axis.ticks.length.x=unit(3,"mm"))+
  
  ylab("Cell viability (%)")+
  xlab("")+
  scale_color_manual(values=c("black","black","black"))+
  guides(fill=guide_legend(title="",override.aes=list(shape=15)),
         color="none")


p
ggsave("/home/users/ayh/Projects/27_A3B/06_Figure_code/Fig1/viability.pdf",p, width=15, height=10, units="in", scale=1)




q1<-ggplot(stat_df%>%filter(APOBEC=="A3A-OE"),aes(x=dose,y=mean_perc,fill=APOBEC,col=dose))+
  geom_bar(stat="identity",position="dodge")+
  
  #facet_wrap(~APOBEC,scales="free_y")+
  scale_y_continuous(breaks=seq(0,100,by=25),
                     labels=seq(0,100,by=25),
                     limits=c(0,110)
  )+
  theme_classic()+
  geom_errorbar(aes(ymin=mean_perc-margin,ymax=mean_perc+margin),
                position=position_dodge(0.9),width=0.2)+
  scale_fill_manual(values=c("#DC8D8D","#ABDDFB"))+
  #theme_test()+
  theme(axis.title=element_text(size=40),
        axis.text=element_text(size=40),
        strip.text=element_text(size=35),
        legend.position="none",
        strip.background=element_blank(),
        legend.title=element_blank(),
        legend.key.size = unit(1.2, 'cm'),
        legend.key = element_rect(color="black"),
        legend.text=element_text(size=30),
        axis.ticks.y=element_line(size=2),
        axis.ticks.x=element_line(size=2),
        axis.ticks.length.y=unit(5,"mm"),
        axis.ticks.length.x=unit(3,"mm"))+
  
  ylab("Cell viability (%)")+
  xlab("Conc. of Dox")+
  scale_color_manual(values=c("black","black","black"))+
  guides(fill=guide_legend(title="",override.aes=list(shape=15)),
         color="none")

#APOBEC     dose mean_perc       sd n       se   margin
#1 A3A-OE 0.1ug/ml  97.81344 3.220850 4 1.610425 3.789915
#2 A3A-OE   3ug/ml  85.29899 3.982718 4 1.991359 4.686391
#3 A3B-OE 0.1ug/ml  76.95041 4.315231 4 2.157615 5.077653
#4 A3B-OE   3ug/ml  44.62012 3.459736 4 1.729868 4.071008
#5   CTRL 0.1ug/ml 104.29149 3.564244 4 1.782122 4.193981
#6   CTRL   3ug/ml 104.27751 5.003622 4 2.501811 5.887670
ggsave("/home/users/ayh/Projects/27_A3B/06_Figure_code/Fig1/viability.A3A.v2.pdf",q1, width=5, height=10, units="in", scale=1)

q2<-ggplot(stat_df%>%filter(APOBEC=="A3B-OE"),aes(x=dose,y=mean_perc,fill=APOBEC,col=dose))+
  geom_bar(stat="identity",position="dodge")+
  
  #facet_wrap(~APOBEC,scales="free_y")+
  scale_y_continuous(breaks=seq(0,100,by=25),
                     labels=seq(0,100,by=25),
                     limits=c(0,110)
  )+
  theme_classic()+
  geom_errorbar(aes(ymin=mean_perc-margin,ymax=mean_perc+margin),
                position=position_dodge(0.9),width=0.2)+
  scale_fill_manual(values=c("#DC8D8D","#ABDDFB"))+
  #theme_test()+
  theme(axis.title=element_text(size=40),
        axis.text=element_text(size=40),
        strip.text=element_text(size=35),
        legend.position="none",
        strip.background=element_blank(),
        legend.title=element_blank(),
        legend.key.size = unit(1.2, 'cm'),
        legend.key = element_rect(color="black"),
        legend.text=element_text(size=30),
        axis.ticks.y=element_line(size=2),
        axis.ticks.x=element_line(size=2),
        axis.ticks.length.y=unit(5,"mm"),
        axis.ticks.length.x=unit(3,"mm"))+
  
  ylab("Cell viability (%)")+
  xlab("Conc. of Dox")+
  scale_color_manual(values=c("black","black","black"))+
  guides(fill=guide_legend(title="",override.aes=list(shape=15)),
         color="none")
ggsave("/home/users/ayh/Projects/27_A3B/06_Figure_code/Fig1/viability.A3B.v2.pdf",q2, width=5, height=10, units="in", scale=1)
dev.off()