library(dplyr)
library(tidyverse)
args = commandArgs(trailingOnly=TRUE)

x=args[1]
vcf<-read_tsv(x)%>%
  mutate(id=gsub(".snp.*","",basename(x)))%>%mutate(read_type=ifelse(grepl("F1R2",basename(x)),"F1R2","F2R1"))%>%
  mutate(context=ifelse(grepl("NCG",basename(x)),"NCG","NCH"))%>%
  mutate(vcf_type=ifelse(grepl(".out",basename(x)),"out","filtered"))

vcf%>%
  group_by(id,read_type,context,vcf_type)%>%
  dplyr::summarise(tot_count=n())%>%
  write.table(gsub(".vcf$",".tot_count.txt",basename(x)),
                   row.names=F,
                   sep="\t",
                   quote=F)


vcf%>%
  group_by(id,read_type,context,vcf_type,sig_cont)%>%
  dplyr::summarise(tot_count=n())%>%
  write.table(gsub(".vcf$",".cont_count.txt",basename(x)),
                   row.names=F,
                   sep="\t",
                   quote=F)
