##from v5, edit just mv dir##

configfile: 'sample_config.yaml'
#configfile: srcdir('path_config.yaml')
configfile: srcdir('path_config.botseq_depth_calc.v6.cont.yaml')

PYTHON = config['PYTHON2']
BEDTOOLS = config['BEDTOOLS']
GENOME= config['GENOME']
EXCLUDE_BED= config['EXCLUDE_BED']
P_DEPTH= config['P_DEPTH']
R_DEPTH= config['R_DEPTH']
R_SS_DEPTH= config['R_SS_DEPTH_CONT_LWH']
RSCRIPT= config['RSCRIPT']
FIN_DEPTH= config['FIN_DEPTH_CONT']
FIN_SS_DEPTH= config['FIN_SS_DEPTH_CONT2']

wildcard_constraints:
    chrom="\d+"        

strand_list=["F1R2","F2R1"]

rule all:
    input:
#        expand("{sample}/{sample}.fin.covered_region.v6.txt", sample=config['sample']);
        expand("{sample}/{sample}.fin.Only_SS_lib.covered_region.v7.cont.F2R1.txt", sample=config['sample'])

rule r_depth:
    params:
        name = lambda x: config['sample'][x.sample]['name'],
        bam = lambda x: config['sample'][x.sample]['s_bam'],
    input:
        txt = "{sample}/{sample}.s.indel.bam.depth.v8.txt",
    output:
#        txt = "{sample}/{sample}.s.indel.bam.processed.F1R2.F2R1.region.v6.bed",
        ss_txt="{sample}/{sample}.s.indel.bam.processed.F1R2.F2R1.Only_SS_lib.region.cont.v6.bed",
    log:
        "logs/{sample}.r_depth.log"
    shell:
 #       "{RSCRIPT} {R_DEPTH} {input.txt}>{log};"
        "{RSCRIPT} {R_SS_DEPTH} {input.txt} {output.ss_txt} > {log};"
#        "touch {output.txt};"
#        "touch {output.ss_txt}"


rule genomecov:
    params:
        name = lambda x: config['sample'][x.sample]['name'],
        bam = lambda x: config['sample'][x.sample]['s_bam'],
    input:
#        bed = "{sample}/{sample}.s.indel.bam.processed.F1R2.F2R1.region.v6.bed",
        ss_bed="{sample}/{sample}.s.indel.bam.processed.F1R2.F2R1.Only_SS_lib.region.cont.v6.bed",
    output:
 #       txt = "{sample}/{sample}.s.indel.bam.processed.F1R2.F2R1.region.v6.bed.covered_region.txt",
        ss_txt1 ="{sample}/{sample}.s.indel.bam.processed.Only_SS_lib.region.cont.v6.bed.covered_region.F1R2.txt",
        ss_txt2 ="{sample}/{sample}.s.indel.bam.processed.Only_SS_lib.region.cont.v6.bed.covered_region.F2R1.txt"
    log:
        "logs/{sample}.genomecov1.log"
    shell:
        "{BEDTOOLS} genomecov -strand + -i {input.ss_bed} -g {GENOME} -bg 1> {output.ss_txt1} 2>{log};"
        "{BEDTOOLS} genomecov -strand - -i {input.ss_bed} -g {GENOME} -bg 1> {output.ss_txt2} 2>{log};"

rule exclude:
    params:
        name = lambda x: config['sample'][x.sample]['name'],
        bam = lambda x: config['sample'][x.sample]['s_bam'],
    input:
#        txt = "{sample}/{sample}.s.indel.bam.processed.F1R2.F2R1.region.v6.bed.covered_region.txt",
        ss_txt1 = "{sample}/{sample}.s.indel.bam.processed.Only_SS_lib.region.cont.v6.bed.covered_region.F1R2.txt",
        ss_txt2 = "{sample}/{sample}.s.indel.bam.processed.Only_SS_lib.region.cont.v6.bed.covered_region.F2R1.txt"
        
    output:
        ss_txt1 = "{sample}/{sample}.s.indel.bam.processed.Only_SS_lib.region.cont.v6.bed.excl.covered_region.F1R2.txt",
        ss_txt2 = "{sample}/{sample}.s.indel.bam.processed.Only_SS_lib.region.cont.v6.bed.excl.covered_region.F2R1.txt"
    log:
        "logs/{sample}.exclude.log"
    shell:
#        "{BEDTOOLS} subtract -a {input.txt} -b {EXCLUDE_BED} 1> {output.txt} 2> {log};"
        "{BEDTOOLS} subtract -a {input.ss_txt1} -b {EXCLUDE_BED} 1> {output.ss_txt1} 2> {log};"
        "{BEDTOOLS} subtract -a {input.ss_txt2} -b {EXCLUDE_BED} 1> {output.ss_txt2} 2> {log};"

rule sum:
    params:
        name = lambda x: config['sample'][x.sample]['name'],
        bam = lambda x: config['sample'][x.sample]['s_bam'],
    input:
        ss_txt1 = "{sample}/{sample}.s.indel.bam.processed.Only_SS_lib.region.cont.v6.bed.excl.covered_region.F1R2.txt",
        ss_txt2 = "{sample}/{sample}.s.indel.bam.processed.Only_SS_lib.region.cont.v6.bed.excl.covered_region.F2R1.txt",
#        txt = "{sample}/{sample}.s.indel.bam.processed.F1R2.F2R1.region.v6.bed.excl.covered_region.txt"
    output:
        ss_txt1 = "{sample}/{sample}.fin.Only_SS_lib.covered_region.v7.cont.F1R2.txt",  # 240401
        ss_txt2 = "{sample}/{sample}.fin.Only_SS_lib.covered_region.v7.cont.F2R1.txt",
#        ss_txt1 = "{sample}/{sample}.fin.Only_SS_lib.covered_region.v7.cont.F1R2.overlap_variant.txt",
#        ss_txt2 = "{sample}/{sample}.fin.Only_SS_lib.covered_region.v7.cont.F2R1.overlap_variant.txt",
#        txt = "{sample}/{sample}.fin.covered_region.v7.cont.txt"
#        ss_txt = "{sample}/{sample}.fin.Only_SS_lib.covered_region.v7.txt"
    log:
        "logs/{sample}.FIN_DEPTH.log"
    shell:
 #       "{PYTHON} {FIN_DEPTH} {input.txt} F > {log};"
#        "{RSCRIPT} {FIN_DEPTH} {input.txt} F > {log};"
        "{RSCRIPT} {FIN_SS_DEPTH} {input.ss_txt1} {output.ss_txt1} F > {log};"
        "{RSCRIPT} {FIN_SS_DEPTH} {input.ss_txt2} {output.ss_txt2} F > {log};"
#        "touch {output.txt};"
#        "touch {output.ss_txt}"
