#####molQTL mapping#####


#!/bin/bash

tissue=$1
Genome_dir=$2

mkdir -p ./$tissue/eQTLmapping/eGenes
mkdir -p ./$tissue/eQTLmapping/eQTL_p
mkdir -p ./$tissue/eQTLmapping/eQTL_csv
mkdir -p ./$tissue/eQTLmapping/sig_eQTL
mkdir -p ./$tissue/eQTLmapping/independent_eQTL
mkdir -p ./$tissue/eQTLmapping/finemapping_eQTL

###eGENE####
python -m tensorqtl $Genome_dir ./$tissue'_TPM.bed' ./$tissue/eQTLmapping/eGenes/$tissue \
   --covariates ./Covariate_$tissue.txt \
   --mode cis

###eQTLs###
python -m tensorqtl $Genome_dir ./$tissue'_TPM.bed' ./$tissue/eQTLmapping/eQTL_p/$tissue \
   --covariates ./Covariate_$tissue.txt \
   --mode cis_nominal

###independent###
python -m tensorqtl $Genome_dir ./$tissue'_TPM.bed' ./$tissue/eQTLmapping/independent_eQTL/$tissue \
    --covariates ./Covariate_$tissue.txt \
    --cis_output ./$tissue/eQTLmapping/eGenes/$tissue'.cis_qtl.txt.gz' \
    --mode cis_independent

###Finemapping###
python -m tensorqtl $Genome_dir ./$tissue'_TPM.bed' ./$tissue/eQTLmapping/finemapping_eQTL/$tissue \
    --covariates ./Covariate_$tissue.txt \
    --cis_output ./$tissue/eQTLmapping/eGenes/$tissue'.cis_qtl.txt.gz' \
    --mode cis_susie

parquet-tools csv ./$tissue/eQTLmapping/finemapping_eQTL/$tissue'.SuSiE_summary.parquet' > ./$tissue/eQTLmapping/finemapping_eQTL/$tissue'.SuSiE_summary.csv'




file="
$tissue.cis_qtl_pairs.1
$tissue.cis_qtl_pairs.2
$tissue.cis_qtl_pairs.3
$tissue.cis_qtl_pairs.4
$tissue.cis_qtl_pairs.5
$tissue.cis_qtl_pairs.6
$tissue.cis_qtl_pairs.7
$tissue.cis_qtl_pairs.8
$tissue.cis_qtl_pairs.9
$tissue.cis_qtl_pairs.10
$tissue.cis_qtl_pairs.11
$tissue.cis_qtl_pairs.12
$tissue.cis_qtl_pairs.13
$tissue.cis_qtl_pairs.14
$tissue.cis_qtl_pairs.15
$tissue.cis_qtl_pairs.16
$tissue.cis_qtl_pairs.17
$tissue.cis_qtl_pairs.18
$tissue.cis_qtl_pairs.19
$tissue.cis_qtl_pairs.20
$tissue.cis_qtl_pairs.21
$tissue.cis_qtl_pairs.22
$tissue.cis_qtl_pairs.23
$tissue.cis_qtl_pairs.24
$tissue.cis_qtl_pairs.25
$tissue.cis_qtl_pairs.26
$tissue.cis_qtl_pairs.27
$tissue.cis_qtl_pairs.28
$tissue.cis_qtl_pairs.29
$tissue.cis_qtl_pairs.31
$tissue.cis_qtl_pairs.33
"

for d in $file;
do
  parquet-tools csv ./$tissue/eQTLmapping/eQTL_p/$d'.parquet' > ./$tissue/eQTLmapping/eQTL_csv/$d'.csv'
done

