library(peer)

# dir_input_output
input_dir <- '/data/3_8T/PEERS/'
output_dir <- '/data/3_8T/PEERS/output/'

# input_list
input_files <- list.files(path = input_dir, pattern = "mol_phenotype_transpose_.*\\.txt$", full.names = TRUE)

# run
for (file in input_files) {
  # tissue_name
  tissue_name <- sub("mol_phenotype_transpose_(.*)\\.txt$", "\\1", basename(file))
  
  # readfile
  expr <- read.table(file, header = TRUE, sep = ' ', row.names = 1)
  
   # run_PEER
  model <- PEER()

  PEER_setPhenoMean(model, as.matrix(expr))
  PEER_setNk(model, 60)
  PEER_setNmax_iterations(model, 1000)
  
  PEER_update(model) 
  
  # result
  factors <- PEER_getX(model)
  weights <- PEER_getW(model)
  precision <- PEER_getAlpha(model)
  residuals <- PEER_getResiduals(model)
  
  options(digits = 3)
  PEER_setAdd_mean(model, TRUE)
  
  # write_file
  write.table(residuals, file = paste0(output_dir, "residual_", tissue_name, ".txt"), append = TRUE, row.names = FALSE)
  write.table(factors, file = paste0(output_dir, "factors_", tissue_name, ".txt"), append = TRUE, row.names = FALSE)
  write.table(weights, file = paste0(output_dir, "weights_", tissue_name, ".txt"), append = TRUE, row.names = FALSE)
  write.table(precision, file = paste0(output_dir, "precision_", tissue_name, ".txt"), append = TRUE, row.names = FALSE)
  
  cat("Processing completed for tissue:", tissue_name, "\n")
}
