#!/bin/bash

samtools_dir=/home/dell/softtools/samtools-1.3.1/bin
data_dir=/home/dell/cleandata/RNAseq/out
bam_dir=/home/dell/cleandata/RNAseq/bam_dir
flagstat_dir=/home/dell/cleandata/RNAseq/flagstat_dir

file="
filename
"
for d in $file;
do
## hisat2 mapping
hisat2 -p 8 /home/dell/reference/duck_ref_zju \
	   -1 $data_dir/$d'_1.fq.gz' \
	   -2 $data_dir/$d'_2.fq.gz' \
	   --known-splicesite-infile splicesites.txt \
	   --pen-noncansplice 1000000 \
       | $samtools_dir/samtools view -b -F 0x4 - | $samtools_dir/samtools sort - -o $bam_dir/$d'.hisat2.mapped.sorted.bam' -T $d'.hisat2.mapped.sorted.tmp' -@ 8 -O bam
$samtools_dir/samtools flagstat $bam_dir/$d'.hisat2.mapped.sorted.bam' > $flagstat_dir/$d'.flagstat.txt' 
## Add reads group
java -jar -Xmx10g /home/share/bin/AddOrReplaceReadGroups.jar \
        I=$bam_dir/$d'.hisat2.mapped.sorted.bam' \
        O=$bam_dir/$d'.hisat2.mapped.sorted.rg.bam' \
        LB=$d SM=$d PL=illumina PU=IAS \
        VALIDATION_STRINGENCY=SILENT
rm $bam_dir/$d'.hisat2.mapped.sorted.bam'
## bam index
$samtools_dir/samtools index $bam_dir/$d'.hisat2.mapped.sorted.rg.bam'
done
