library(bnlearn)
library(Rgraphviz)

# Set directories
input_dir <- "F:/..."
output_dir <- input_dir

# Output file names
output_arcs_file <- paste0(output_dir, "BayesianNetwork_BootstrappedEdges.txt")
#output_graph_pdf <- paste0(output_dir, "BayesianNetwork_Plot_Bootstrap.pdf")

# Load eigengene data
liver  <- read.table(paste0(input_dir, "Liver_Merged_Eigengene.txt"),  header = TRUE, row.names = 1)
spleen <- read.table(paste0(input_dir, "Spleen_Merged_Eigengene.txt"), header = TRUE, row.names = 1)
shell  <- read.table(paste0(input_dir, "Shell_Merged_Eigengene.txt"),  header = TRUE, row.names = 1)

# Optional: include ovary if needed
# ovary <- read.table(paste0(input_dir, "Ovarian_Merged_Eigengene.txt"), header = TRUE, row.names = 1)
# colnames(ovary) <- paste0("Ovary_", colnames(ovary))

# Add tissue prefixes to column names
colnames(liver)  <- paste0("Liver_",  colnames(liver))
colnames(spleen) <- paste0("Spleen_", colnames(spleen))
colnames(shell)  <- paste0("Shell_",  colnames(shell))

# Match common samples across tissues
common_samples <- Reduce(intersect, list(
  rownames(liver), rownames(spleen), rownames(shell)
  # , rownames(ovary)
))

liver_sub  <- liver[common_samples, ]
spleen_sub <- spleen[common_samples, ]
shell_sub  <- shell[common_samples, ]
# ovary_sub <- ovary[common_samples, ]

#Merge eigengene matrices across tissues
eigengene_all <- cbind(liver_sub, spleen_sub, shell_sub)
# eigengene_all <- cbind(liver_sub, spleen_sub, shell_sub, ovary_sub)

# Construct Bayesian network via bootstrapping
set.seed(1234)
boot_res <- boot.strength(
  data = eigengene_all,
  R = 1000,
  algorithm = "hc",
  algorithm.args = list(score = "bic-g")
)

# Average network: retain edges with confidence > 0.85
avg_net <- averaged.network(boot_res, threshold = 0.85)

# Save all bootstrapped edge strengths
write.table(boot_res, file = output_arcs_file, sep = "\t", quote = FALSE, row.names = FALSE)
