#!/bin/sh

#bam2junc
for bamfile in `ls /home/dell/cleandata/*.hisat2.mapped.sorted.rg.bam`; do
    echo Converting $bamfile to $bamfile.junc
    regtools junctions extract -a 8 -m 50 -M 500000 $bamfile -s XS -o $bamfile.junc
    echo $bamfile.junc >> juncfiles.txt
done

#Intron clustering
python /home/dell/softtools/leafcutter/clustering/leafcutter_cluster_regtools.py -j /home/dell/cleandata/juncfiles.txt -m 50  -k  -o /data/3_8T/leafcutter/tissues -l 500000

#pheno preparation
python /home/dell/softtools/leafcutter/scripts/prepare_phenotype_table.py -p 50 /data/3_8T/leafcutter/tissues/leafcutter_perind.counts.gz
