#!/bin/bash
for (( d=1; d<=29; d++ ))
do
n=$[$d+2]
#STEP1
cut -f1-2,$n trait.txt >'T'$d'.txt'
emmax -v -d 10 -t  /home/dell/cleandata/BMK200820-AB852-S01-0103-42/mapcall/DEPLS.fltsnp.maf0.03 -p 'T'$d'.txt' -k  /home/dell/cleandata/BMK200820-AB852-S01-0103-42/mapcall/DEPLS.fltsnp.maf0.03.hIBS.kinf -o /home/dell/xiyang/DEPLS/MZCDL/'gwas.T'$d -c /home/dell/xiyang/DEPLS/MZCDL/covariates.txt
#STEP2 
paste /home/dell/cleandata/BMK200820-AB852-S01-0103-42/mapcall/DEPLS.fltsnp.maf0.03.headcol 'gwas.T'$d'.ps' >'gwas.T'$d'.result.txt'
awk '{$3=null;$5=null;$6=null;print}' 'gwas.T'$d'.result.txt' >'gwas.T'$d'.assoc.txt'
sed -i '1i\CHR SNPID BP P' 'gwas.T'$d'.assoc.txt'
perl /home/dell/softtools/emmaxfilter.pl 'gwas.T'$d'.assoc.txt' 'gwas.T'$d'.assoc.plot.txt'
rm 'gwas.T'$d'.result.txt'
rm 'gwas.T'$d'.ps'
rm 'gwas.T'$d'.assoc.txt'
echo "source(\"/home/dell/softtools/MANHATTAN_QQ.r\")
setwd(\"/home/dell/xiyang/DEPLS/MZCDL\")
mydata=read.table(\"gwas.T"$d".assoc.plot.txt\", header=TRUE)
GAPIT.Manhattan(mydata,name.of.trait=\"T"$d"\")
mydata=mydata[order(as.numeric(mydata[,3]),decreasing = FALSE),]
myoutdata=mydata[1:2001,]
myoutdata[,3] <-  -log10(myoutdata[,3])
write.table(myoutdata,file=\"gwas.T"$d".assoc.t2000.txt\", col.names=T, row.names=F, quote=F,sep=\" \")" >plot.T"$d".r
perl -e 'system ("R <plot.T'$d'.r --vanilla")' &
done
