
organs="liver ovary spleen shell"

file="T1 T2 T3 ..."

for organ in $organs
do
    for d in $file
    do
        
        gwas_file="/home/dell/xiyang/DEPLS/CDL_SCALED/File_for_coloc/gwas.${d}.sig.region.txt"
        if [ ! -f "$gwas_file" ]; then
            echo "Warning: GWAS file for $d not found, skipping..."
            continue  
        fi

        
        eqtl_dir="/data/3_8T/molecularQTLmapping/2025RevisionMolQTL/${organ}/eQTLmapping/eQTL_csv"
        sqtl_dir="/data/3_8T/molecularQTLmapping/2025RevisionMolQTL/${organ}/sQTLmapping/sQTL_csv"
        apaQTL_dir="/data/3_8T/molecularQTLmapping/2025RevisionMolQTL/${organ}/apaQTLmapping/apaQTL_csv"

        Rscript COLOC_withSNPoutput.R $gwas_file $eqtl_dir ./${organ}_eQTL_${d}_result.csv $organ
   
        Rscript COLOC_withSNPoutput.R $gwas_file $sqtl_dir ./${organ}_sQTL_${d}_result.csv $organ

        Rscript COLOC_withSNPoutput.R $gwas_file $apaQTL_dir ./${organ}_apaQTL_${d}_result.csv $organ

    done
done
