% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QuadST-main-functions.R
\name{create_integrated_matrix}
\alias{create_integrated_matrix}
\title{Create anchor-neighbor cell type pair integrated matrix}
\usage{
create_integrated_matrix(
  x,
  cell_id,
  cell_coord1,
  cell_coord2,
  cell_type,
  anchor,
  neighbor,
  k = 1,
  d.limit = Inf
)
}
\arguments{
\item{x}{A \code{SingleCellExperiment} class.}

\item{cell_id}{A column name of \code{colData(object)} that stores each cell's unique id.}

\item{cell_coord1}{A column name of \code{colData(object)} that stores the first spatial coordinate of each cell.}

\item{cell_coord2}{A column name of \code{colData(object)} that stores the second spatial coordinate of each cell.}

\item{cell_type}{A column name of \code{colData(object)} that stores cell types of each cell.}

\item{anchor}{A name of cell type to be used for anchor cell type.}

\item{neighbor}{A name of cell type to be used for neighbor cell type.}

\item{k}{Default = 1. Find k nearest neighbors for the anchor cell.}

\item{d.limit}{Default=Inf. The limit of cell-cell distance for cell pairing. Cells over this distance limit
will not be paired even though they are the k nearest neighbors.}
}
\value{
An anchor-neighbor integrated matrix in the \code{SingleCellExperiment} class.
}
\description{
The data includes anchor-neighbor cell pair distance, anchor cells' expression, and covariates
}
