% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QuadST-main-functions.R
\name{create_quantile_levels}
\alias{create_quantile_levels}
\title{Create a set of evenly distributed quantile levels}
\usage{
create_quantile_levels(min_sample_per_quantile, cell_count, max_default = 49)
}
\arguments{
\item{min_sample_per_quantile}{A minimum number of samples in a given quantile level.}

\item{cell_count}{The number of anchor cell counts.}

\item{max_default}{Default = 49. The maximum number of quantile levels to use. Default = 49 means
quantile levels 0.02, 0.04, ..., 0.98 are under consideration.}
}
\value{
A vector of quantile levels.
}
\description{
Create a set of evenly distributed quantile levels
}
\examples{
data("seqFISHplus_scran_sce")
cell_id = "cellID"
cell_coord1 = "x"
cell_coord2 = "y"
cell_type = "cellClass"
anchor = "Excitatory neuron"
neighbor = "Astrocyte"
covariate = "FOV"
sce_an = create_cellpair_matrix(seqFISHplus_scran_sce, cell_id, cell_coord1, cell_coord2, cell_type, anchor, neighbor, cov=covariate)
anchor_cell_count <- length(colData(sce_an)[, cell_id])
dist_taus <- create_quantile_levels(min_sample_per_quantile = 5, cell_count = anchor_cell_count, max_default = 49)


}
