# -*- coding: utf-8 -*-
import os
import numpy as np
import pandas as pd
import argparse
from sklearn.decomposition import PCA
parser = argparse.ArgumentParser(description='manual to this script')
parser.add_argument("--WorkSpace", type=str, default="./")
parser.add_argument("--X", type=str, default="0")
parser.add_argument("--y", type=str, default="0")
parser.add_argument("--SNPinfo", type=str, default="0")
args = parser.parse_args()
print("start read")
features=np.load(args.X)
labels=np.load(args.y)
labels_unique=np.unique(labels)
with open(args.SNPinfo,"r") as f:
    line=f.readlines()
os.chdir(args.WorkSpace)
feature_info=line
print("cal")
pca = PCA(n_components=100,)
pca.fit(features)
k1_spss = pca.components_.T
weight = (np.dot(k1_spss, pca.explained_variance_ratio_)) / np.sum(pca.explained_variance_ratio_)
li_PCA=[]
for i in range(len(feature_info)):
    li_PCA.append([feature_info[i].strip("\n"),weight[i]])
li_PCA=sorted(li_PCA, key=lambda x:(x[1]), reverse=True)

f=open("pca_weight","w")
for i in li_PCA:
    f.write("{}\t{}\n".format(i[0],i[1]))
f.close()
