#! /bin/bash

# train set and test set
python pre.py

# Feature Selection
# PCA
python PCA.py --WorkSpace ./ --X ./X_train.npy --y ./y_train.npy --SNPinfo SNP_info.txt

# In
plink --bfile snps --freq --within breed.txt --out in_freq
python In.py in_freq.frq.strat

# SS
for((k=1; k<=60; k++))
do
    for((j=k+1; j<=60; j++))
    do
        vcftools --vcf ./snps.vcf --weir-fst-pop ./pop/pVCF${j}.txt --weir-fst-pop ./pop/pVCF${k}.txt --out fst_${j}_${k} > ./fst_${j}_${k}.log 2>&1 &
    done
done

for((j=1; j<=60; j++))
do
    vcftools --vcf ./snps.vcf --keep ./pop/pVCF${j}.txt --window-pi 10000 --out pop${j}_10kb.Pi > ./pop${j}_pi.log 2>&1 &
done

python SS.py

# Fst
vcftools --vcf ./snps.vcf --weir-fst-pop ./pop/pVCF1.txt --weir-fst-pop ./pop/pVCF2.txt --weir-fst-pop ./pop/pVCF3.txt --weir-fst-pop ./pop/pVCF4.txt --weir-fst-pop ./pop/pVCF5.txt --weir-fst-pop ./pop/pVCF6.txt --weir-fst-pop ./pop/pVCF7.txt --weir-fst-pop ./pop/pVCF8.txt --weir-fst-pop ./pop/pVCF9.txt --weir-fst-pop ./pop/pVCF10.txt ...... --out WholePop.Fst > ./whole_Fst.log 2>&1 &
