#if 1
//rintf(stderr, "----------------------------------------------------------------------");
fprintf(stderr, "\n");
fprintf(stderr, "  A meryl command line is formed as a series of actions, possibly\n");
fprintf(stderr, "  grouped using square brackets.  Each action operates on the file(s)\n");
fprintf(stderr, "  that are listed after it.\n");
fprintf(stderr, "      meryl -k 57 output out.meryl union [count 1.fa] [count 2.fa]\n");
fprintf(stderr, "\n");
fprintf(stderr, "  OPTIONS:\n");
fprintf(stderr, "    Options are global and affect all actions regardless of where the\n");
fprintf(stderr, "    option occurs in the command line.\n");
fprintf(stderr, "\n");
fprintf(stderr, "      -k       Sets the kmer size for 'count' actions.  If any databases\n");
fprintf(stderr, "               are supplied, the kmer size of the database is used; all\n");
fprintf(stderr, "               databases must be the same kmer size and if -k is supplied,\n");
fprintf(stderr, "               it must agree with the databases.\n");
fprintf(stderr, "\n");
fprintf(stderr, "      -l       Sets the label size for 'count' (and other) actions.\n");
fprintf(stderr, "\n");
fprintf(stderr, "      -m       Maximum memory to use when counting kmers.\n");
fprintf(stderr, "\n");
fprintf(stderr, "      -t       Number of threads to use.  For non-counting operations, a\n");
fprintf(stderr, "               power of two (1, 2, 4, 8, 16, 32 or 64) is suggested.\n");
fprintf(stderr, "\n");
fprintf(stderr, "      -V[...]  Increase verbosity by the number of letters in the\n");
fprintf(stderr, "               option.  Examples:\n");
fprintf(stderr, "                 -V    increase verbosity by 1.\n");
fprintf(stderr, "                 -VvVv increase verbosity by 4.\n");
fprintf(stderr, "                 -VIII increase verbosity by 4.\n");
fprintf(stderr, "      -Q       Disable all informative messages.  Errors and warnings\n");
fprintf(stderr, "               are still emitted.\n");
fprintf(stderr, "      -P       Enable progress reports showint the number of kmers\n");
fprintf(stderr, "               processed etc.\n");
fprintf(stderr, "      -C       Halts execution after the action tree is generated.\n");
fprintf(stderr, "               No kmers are processed; no outputs are created.\n");
fprintf(stderr, "\n");
fprintf(stderr, "  COMMANDS:\n");
fprintf(stderr, "\n");
fprintf(stderr, "    statistics           display total, unique, distnict, present number of the kmers on the screen.  accepts exactly one input.\n");
fprintf(stderr, "    histogram            display kmer frequency on the screen as 'frequency<tab>count'.  accepts exactly one input.\n");
fprintf(stderr, "    print                display kmers on the screen as 'kmer<tab>count'.  accepts exactly one input.\n");
fprintf(stderr, "\n");
fprintf(stderr, "    count                Count the occurrences of canonical kmers in the input.  must have 'output' specified.\n");
fprintf(stderr, "    count-forward        Count the occurrences of forward kmers in the input.  must have 'output' specified.\n");
fprintf(stderr, "    count-reverse        Count the occurrences of reverse kmers in the input.  must have 'output' specified.\n");
fprintf(stderr, "      k=<K>              create mers of size K bases (mandatory).\n");
fprintf(stderr, "      n=<N>              expect N mers in the input (optional; for precise memory sizing).\n");
fprintf(stderr, "      memory=M           use no more than (about) M GB memory.\n");
fprintf(stderr, "      threads=T          use no more than T threads.\n");
fprintf(stderr, "      compress           compress homopolymer runs to a single letter.\n");
fprintf(stderr, "\n");
fprintf(stderr, "    less-than N          return kmers that occur fewer than N times in the input.  accepts exactly one input.\n");
fprintf(stderr, "    greater-than N       return kmers that occur more than N times in the input.  accepts exactly one input.\n");
fprintf(stderr, "    equal-to N           return kmers that occur exactly N times in the input.  accepts exactly one input.\n");
fprintf(stderr, "    not-equal-to N       return kmers that do not occur exactly N times in the input.  accepts exactly one input.\n");
fprintf(stderr, "\n");
fprintf(stderr, "    increase X           add X to the count of each kmer.\n");
fprintf(stderr, "    decrease X           subtract X from the count of each kmer.\n");
fprintf(stderr, "    multiply X           multiply the count of each kmer by X.\n");
fprintf(stderr, "    divide X             divide the count of each kmer by X.\n");
fprintf(stderr, "    divide-round X       divide the count of each kmer by X and round results. count < X will become 1.\n");
fprintf(stderr, "    modulo X             set the count of each kmer to the remainder of the count divided by X.\n");
fprintf(stderr, "\n");
fprintf(stderr, "    union                return kmers that occur in any input, set the count to the number of inputs with this kmer.\n");
fprintf(stderr, "    union-min            return kmers that occur in any input, set the count to the minimum count\n");
fprintf(stderr, "    union-max            return kmers that occur in any input, set the count to the maximum count\n");
fprintf(stderr, "    union-sum            return kmers that occur in any input, set the count to the sum of the counts\n");
fprintf(stderr, "\n");
fprintf(stderr, "    intersect            return kmers that occur in all inputs, set the count to the count in the first input.\n");
fprintf(stderr, "    intersect-min        return kmers that occur in all inputs, set the count to the minimum count.\n");
fprintf(stderr, "    intersect-max        return kmers that occur in all inputs, set the count to the maximum count.\n");
fprintf(stderr, "    intersect-sum        return kmers that occur in all inputs, set the count to the sum of the counts.\n");
fprintf(stderr, "\n");
fprintf(stderr, "    subtract             return kmers that occur in the first input, subtracting counts from the other inputs\n");
fprintf(stderr, "\n");
fprintf(stderr, "    difference           return kmers that occur in the first input, but none of the other inputs\n");
fprintf(stderr, "    symmetric-difference return kmers that occur in exactly one input\n");
fprintf(stderr, "\n");
fprintf(stderr, "  MODIFIERS:\n");
fprintf(stderr, "\n");
fprintf(stderr, "    output O             write kmers generated by the present command to an output  meryl database O\n");
fprintf(stderr, "                         mandatory for count operations.\n");
fprintf(stderr, "\n");
fprintf(stderr, "  EXAMPLES:\n");
fprintf(stderr, "\n");
fprintf(stderr, "  Example:  Report 22-mers present in at least one of input1.fasta and input2.fasta.\n");
fprintf(stderr, "            Kmers from each input are saved in meryl databases 'input1' and 'input2',\n");
fprintf(stderr, "            but the kmers in the union are only reported to the screen.\n");
fprintf(stderr, "\n");
fprintf(stderr, "            meryl print \\\n");
fprintf(stderr, "                    union \\\n");
fprintf(stderr, "                      [count k=22 input1.fasta output input1] \\\n");
fprintf(stderr, "                      [count k=22 input2.fasta output input2]\n");
fprintf(stderr, "\n");
fprintf(stderr, "  Example:  Find the highest count of each kmer present in both files, save the kmers to\n");
fprintf(stderr, "            database 'maxCount'.\n");
fprintf(stderr, "\n");
fprintf(stderr, "            meryl intersect-max input1 input2 output maxCount\n");
fprintf(stderr, "\n");
fprintf(stderr, "  Example:  Find unique kmers common to both files.  Brackets are necessary\n");
fprintf(stderr, "            on the first 'equal-to' command to prevent the second 'equal-to' from\n");
fprintf(stderr, "            being used as an input to the first 'equal-to'.\n");
fprintf(stderr, "\n");
fprintf(stderr, "            meryl intersect [equal-to 1 input1] equal-to 1 input2\n");
fprintf(stderr, "\n");
#endif
