module add ucsctools

in_file=${1}
out_file=${2}
chain_file=${3}
script_dir=${4}

# Pull out the file header for use in the output file
head -1 ${in_file} \
> ibed_header.txt

# Split the interaction into two separate files, one for each end.
# Also add a unique identifier for each interaction that will be used to combine ends after lifting over.
# Keep track of original coordinates so we can check if chromosome changed during liftOver.
awk '{if(NR > 1) {
print $1"\t"$2"\t"$3"\t"$4"\tinteraction_"(NR-1)"\t"$0}}' \
${in_file} \
> end1_originalGenome.bed

awk '{if(NR > 1) {
print $5"\t"$6"\t"$7"\t"$8"\tinteraction_"(NR-1)"\t"$0}}' \
${in_file} \
> end2_originalGenome.bed

# Lift over each end separately
liftOver -bedPlus=3 \
end1_originalGenome.bed \
${chain_file} \
end1_targetGenome.bed \
unmapped_end1.bed

liftOver -bedPlus=3 \
end2_originalGenome.bed \
${chain_file} \
end2_targetGenome.bed \
unmapped_end2.bed

# Synchronize the interactions.
# The end1_originalGenome file is provided so that we can tested for any interactions that were dropped because both ends failed to liftOver.
python ${script_dir}/syncLiftedOverInteractionEnds.py \
end1_targetGenome.bed \
end2_targetGenome.bed \
end1_originalGenome.bed \
${out_file} \
ibed_header.txt
