## Overview

This folder contains scripts for lifting over Hi-C interactions between genome builds. The workflow for lifting over Hi-C interactions is:
1. Lift over each end of the interaction separately using the UCSC liftOver commandline tool. Unique IDs are added to each end of an interaction before lifting over so that they can be combined after lifting over. The original coordinates before lifting over are also retained to determine if either end lifted to a different chromosome.
2. Remove any interactions where one or both ends:
a. Did not map to a position in the new genome build.
b. Mapped to multiple locations in the new build.
c. Mapped to a different chromosome in the new build.

## Dependencies

1. The UCSC liftOver commandline tool.
2. A liftOver over.chain file from UCSC that contains the mapping between the old and new genome builds.

## Usage

```
/bin/bash ${script_dir}/liftOverInteractBed.sh \
${in_file} \
${out_file} \
${chain_file} \
${script_dir}
```

Where:
- ${in_file} is the file containing the interactions to be lifted over. The file is expected to contain a header on the first line. Columns 1-4 of the file should contain the chromosome, start position, end position, and name of the first end of the interaction. Columns 5-8 should contain the chromosome, start, end, and name of the second end of the interaction. The file can have any number of additional columns, which will be transferred over to the lifted over file.
- ${out_file} is the name of the output file where lifted over interactions will be written.
- ${chain_file} is the over.chain file from UCSC.
- ${script_dir} is the full path of the directory containing the scripts.

## Outputs

1. A file with interactions that successfully lifted over to the new genome build. The columns should be identical to the input file except the coordinates now match the new build. Additional columns after column 8 will be transferred from the input file without modification.
2. unmapped_end1.bed and unmapped_end2.bed list regions that the UCSC liftOver tool was not able to lift to the new build.
3. unmapped_interactions.txt lists which interactions did not lift over and gives a description of why the lift over was unsuccessful: either end did not lift over, either end lifted to multiple locations in the new build, either end lifted to a different chromosome.
