#!/usr/bin/perl

# 读取show-tiling -a 结果 (Read the result of show-tiling -a)
# 格式类似show-coords -clTH (Format similar to show-coords -clTH)
# 输出包括： (Output includes:)
# [S1]	[E1]	[S2]	[E2]	[LEN 1]	[LEN 2]	[% IDY]	[LEN R]	[LEN Q]	[COV R]	[COV Q]	[TAGS]	
# 246056	246240	1	185	185	185	95.68	43270923	736	0	25.14	1	Chr1:225786-225922
# 本脚本计算相邻匹配的距离 (This script calculates the distance to the previous match)

my $s1_last = 1; # 上一条匹配的起始位置 (Starting position of the previous match)
my $e1_last = 1; # 上一条匹配的结束位置 (Ending position of the previous match)
my $s2_last; # 用于存储上一条匹配的s2 (Used to store s2 of the previous match)
my $e2_last; # 用于存储上一条匹配的e2 (Used to store e2 of the previous match)
my $ref_last = "no"; # 记录上一条匹配的参考染色体 (Record the reference chromosome of the previous match)
my $query_last = "no"; # 记录上一条匹配的查询染色体 (Record the query chromosome of the previous match)
while (<>){
	chomp;
	my ($s1, $e1, $s2, $e2, $len1, $len2, $idy, $lenR, $lenQ, $covR, $covQ, $ref, $query) = split /\t/;
	my $ref_distence = $s1 - $e1_last;
	
	my $ref_chr = $ref;
	$ref_chr =~ s/chr//i;
	my ($query_chr, $query_pos) = split /:/, $query;
	$query_chr =~ s/chr//i;
	
	if ($query_chr eq $ref_chr){ #先判断同染色体 (Check if the query and reference chromosomes are the same)
		if ($query eq $query_last){ #判断是否同norg (Check if it is the same norg)
			# 输出参考染色体，起始和结束位置，查询染色体，以及计算的距离 (Output reference chromosome, start and end positions, query chromosome, and calculated distance)
			print $ref, "\t", $s1_last, "\t", $e1, "\t", $query, "\t", $ref_distence, "\n";
		}
	}
	
	# 更新记录的变量为当前匹配的结果 (Update the recorded variables with the current match)
	$s1_last = $s1;
	$e1_last = $e1;
	$s2_last = $s2;
	$e2_last = $e2;
	$ref_last = $ref;
	$query_last = $query;
}