import pandas as pd
import numpy as np
import os
import seaborn as sns
import matplotlib.pyplot as plt
import matplotlib as mpl
mpl.rcParams['pdf.fonttype'] = 42
mpl.rcParams['ps.fonttype'] = 42

cells = ['H1','endoderm']
chroms = ['chr'+str(i) for i in range(1,23)]
T = len(cells)
one = []
two = []
count = 0 #np.zeros(int(T*(T-1)/2),dtype=int)

cc = 0
for i in range(T):
	c1 = cells[i]
	for j in range(i+1,T):
		c2 = cells[j]
		one.append(c1)
		two.append(c2)
		for chro in chroms:
			print(chro,c1,c2)
			fpath = 'db_output/{}/{}_vs_{}_significantly_differential_boundary_regions.txt'.format(chro,c1,c2)
			if os.path.getsize(fpath) > 0:
				tmp = pd.read_csv(fpath,sep="\t",index_col=False,header=None)
				count += tmp.shape[0]
		cc += 1
df = pd.DataFrame({'one':one,'two':two,'count':[count]})
df.to_csv('count_sig_db.txt',sep="\t",index=False)
#df = df.pivot('one','two','count')
#sns.heatmap(df,cmap='Reds',annot=True,fmt=".1f")
#plt.savefig('count_sig_db_cardio.pdf')	


