import pandas as pd
import numpy as np
import seaborn as sns
import matplotlib.pyplot as plt
import sys
import matplotlib as mpl
mpl.rcParams['pdf.fonttype'] = 42
mpl.rcParams['ps.fonttype'] = 42

for c in ['ES','NPC','CN']:
	df = pd.read_csv('mean_gc_per_cluster/{}.txt'.format(c),sep="\t",index_col='chrom')*100
	sns.heatmap(df,cmap='Purples',annot=True,fmt='.1f')
	plt.savefig('mean_gc_per_cluster/{}.pdf'.format(c))
	plt.close()



