import numpy as np
import pandas as pd

chrom = ['chr'+str(i) for i in range(1, 20)]
cells = ['ES','NPC','CN']
d1 = {1:'A',2:'B'}
d2 = {1:'B',2:'A'}

meangc = pd.read_csv('mean_gc_per_cluster/ES.txt',sep="\t",index_col=False)

for _,row in meangc.iterrows():
	chro = 'chr' + str(int(row['chrom']))
	mean0 = row['cluster0']
	mean1 = row['cluster1']
	#print(chro,mean0,mean1)
	bed = pd.read_csv('bed/{}_100kb.bed'.format(chro),sep="\t",header=None,usecols=[0,1],names=['chrom','start'],index_col=False)
	df = pd.read_csv('tgif_output/{}/cluster_assignment.txt'.format(chro),sep="\t",index_col=False)
	df+=1
	df = pd.concat((bed,df),axis=1).dropna()
	for cell in cells:
		if mean0 > mean1:
			df[cell] = df[cell].astype(int).map(d1)
		else:
			df[cell] = df[cell].astype(int).map(d2)
			#print('flip')
	df.to_csv('annotated/{}_compartment_annotation.txt'.format(chro),sep="\t",index=False)

