import numpy as np
import pandas as pd
import seaborn as sns
import matplotlib.pyplot as plt
from scipy.sparse import coo_matrix as coo
from matplotlib import gridspec
import sys
cells = [sys.argv[1],sys.argv[2]] #this script only works if there are 2 timepoints!
T = len(cells)
chroms = ['chr1']

for chro in chroms:
    print(chro)

    mats = {}
    for cell in cells:
        mat = np.loadtxt('oe_mat/{}/{}_oe.txt'.format(chro,cell))
        mat = np.corrcoef(mat)
        mats[cell] = mat

    for t1 in range(T):
        cell1 = cells[t1]
        mat1 = mats[cell1]
        for t2 in range(t1+1,T):
            cell2 = cells[t2]
            print(cell1,cell2)
            mat2 = mats[cell2]

            diffmat = np.absolute(mat1-mat2)

            sigdc = pd.read_csv('output/{}/{}_vs_{}_significantly_differential_compartmental_regions_DEBUG.txt'.format(chro,cell1,cell2), sep="\t",header=None,usecols=[0,1,2,5],names=['chro','start','end','padj'],index_col=False)
            sigdc.dropna(inplace=True)
            sigdc['idx'] = range(sigdc.shape[0])
            sigdc['-log(pval)'] = -1* np.log(sigdc.padj)
            order = np.argsort(sigdc.padj)
            padj_sorted = sigdc.padj.values[order]
            #diffmat = diffmat[order]
            #diffmat = diffmat[:,order]

            fig = plt.figure(figsize=(8,9))
            gs = fig.add_gridspec(2,1,height_ratios=[0.15,1])
            ax1 = fig.add_subplot(gs[0,0])
            ax2 = fig.add_subplot(gs[1,0])
            sns.lineplot(data=sigdc,x='idx',y='-log(pval)',ax=ax1)
            #ax1.set_frame_on(False)
            ax1.spines['right'].set_visible(False)
            ax1.spines['top'].set_visible(False)
            ax1.set_xlabel(chro)
            ax1.set_xlim(0,sigdc.shape[0])
            ax1.set_xticklabels([])

            sns.heatmap(diffmat,ax=ax2,cmap='Oranges',cbar=False, vmax=0.7)
            ax2.set_xticks([])
            ax2.set_yticks([])
            plt.tight_layout()
            plt.savefig('{}_vs_{}_{}'.format(cell1,cell2,chro))
            plt.close() 
