import pandas as pd
import numpy as np
import os
import seaborn as sns
import matplotlib.pyplot as plt
import matplotlib as mpl
mpl.rcParams['pdf.fonttype'] = 42
mpl.rcParams['ps.fonttype'] = 42

cells = ['ES','NPC','CN']
T = len(cells)
one = []
two = []
count = np.zeros(int(T*(T-1)/2),dtype=int)
chroms = ['chr'+str(i) for i in range(1, 20)]

cc = 0
for i in range(T):
	c1 = cells[i]
	for j in range(i+1,T):
		c2 = cells[j]
		one.append('{:d}){:}'.format(i,c1))
		two.append('{:d}){:}'.format(j,c2))
		for chro in chroms:
			print(chro,c1,c2)
			fpath = 'dc_output/{}/{}_vs_{}_significantly_differential_compartmental_regions.txt'.format(chro,c1,c2)
			if os.path.getsize(fpath) > 0:
				tmp = pd.read_csv(fpath,sep="\t",index_col=False,header=None)
				count[cc] += tmp.shape[0]
		cc += 1
df = pd.DataFrame({'one':one,'two':two,'count':count})
print(df)
df = df.pivot('one','two','count')
sns.heatmap(df,cmap='Reds',annot=True,fmt=".1f")
plt.savefig('count_sig_dc_mouse.pdf')	


