import pandas as pd
from sklearn.metrics.cluster import rand_score
cells = ['ES','NPC','CN']
T = len(cells)
chros = ['chr'+str(x) for x in range(1, 20)]

with open('rand_index.txt','w') as o:

	o.write('Chrom\tOne\tTwo\tRand Index\n')
	for c in chros:
		cid = pd.read_csv('tgif_output/{}/cluster_assignment.txt'.format(c),sep="\t",index_col=False)+1
		print(cid)
		cid.dropna(inplace=True)
		for i in range(T):
			c1 = cells[i]
			for j in range(i+1,T):
				c2 = cells[j]
				r = rand_score(cid[c1],cid[c2])
				o.write('{}\t{:d}-{}\t{:d}-{}\t{:.3f}\n'.format(c,i,c1,j,c2,r))
 
		
