import pandas as pd
import seaborn as sns
import matplotlib.pyplot as plt
import numpy as np
import sys
import matplotlib as mpl
mpl.rcParams['pdf.fonttype'] = 42
mpl.rcParams['ps.fonttype'] = 42
sns.set_context("talk")

df = pd.read_csv('rand_index.txt',sep="\t",index_col=False)
df = df.groupby(['One','Two'])['Rand Index'].mean().reset_index()
df = df.pivot("One","Two","Rand Index")
fig = plt.figure(figsize=(10,8))
sns.heatmap(df, cmap="Greens",vmin=0.5,vmax=0.9,annot=True,fmt=".3f",cbar_kws={'label':'Rand Index'})
#ax = sns.violinplot(y='-log(pval+e-5)',x='config',data=df,palette='Set2')
#ax = sns.swarmplot(x='config',y='score',hue='type',data=df)
#ax.set_yscale("log")
plt.xlabel('')
plt.ylabel('')
plt.tight_layout()
plt.savefig('rand_index.pdf')
