import pandas as pd
import numpy as np
import sys

res1=sys.argv[1] #e.g.10kb
res2=sys.argv[2] #e.g.50kb, res2 should be coarser than res1
lcm= int(sys.argv[3]) #least common multiple, 50000
o = open('jaccard_{:}_vs_{:}.txt'.format(res1,res2),'w')
o.write('method\tchro\tone\ttwo\tintersection\tunion\tjaccard\n')
chros = ['chr'+str(i) for i in range(1,20)]

for chro in chros:
	one = pd.read_csv('bed/{}/ES_{}_{}.bed'.format(res1,chro,res1),sep="\t",index_col=False,header=None,names=['chro','start','end','idx'])
	bd1 = pd.read_csv('output/{:}/{}/significant_boundaries_summit_only.txt'.format(res1,chro),sep="\t",index_col=False)
	one = one.start.values[bd1.ES == 1].astype(int)
	one = np.unique(np.trunc(one/lcm))

	two = pd.read_csv('bed/{}/ES_{}_{}.bed'.format(res2,chro,res2),sep="\t",index_col=False,header=None,names=['chro','start','end','idx'])
	bd2 = pd.read_csv('output/{:}/{}/significant_boundaries_summit_only.txt'.format(res2,chro),sep="\t",index_col=False)
	two = two.start.values[bd2.ES == 1].astype(int)
	two = np.unique(np.trunc(two/lcm))

	u_cnt = np.union1d(one,two).shape[0]
	i_cnt = np.intersect1d(one,two).shape[0]
	o.write('TGIF-DB\t{:}\t{:}\t{:}\t{:}\t{:d}\t{:.3f}\n'.format(chro,res1,res2,int(i_cnt),int(u_cnt),i_cnt/u_cnt))
o.close()
#print(squareform(pdist(sigs)))
#		cnt print= np.sum(sig, axis=0)
#		for i in range(sig.shape[1]):
#			o.write('{}{}\ttask{:d}\t{:d}\n'.format(config,test,i+1,int(cnt[i])))	

